/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class URIUtils {
    private URIUtils() {
    }

    public static Map<String, String> splitFragment(String location) {
        URI uri = null;
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return URIUtils.splitFragment(uri);
    }

    public static Map<String, String> splitFragment(URI uri) {
        return URIUtils.splitQuery(uri.getFragment());
    }

    public static Map<String, String> splitQuery(String q) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (q != null) {
            for (NameValuePair pair : URLEncodedUtils.parse((String)q, (Charset)StandardCharsets.UTF_8)) {
                params.put(pair.getName(), pair.getValue());
            }
        }
        return params;
    }
}

