/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.authorization;

import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationStrategyVisitor;
import com.openshift.restclient.authorization.IRequest;

public class TokenAuthorizationStrategy
implements IAuthorizationStrategy {
    private final String token;

    public TokenAuthorizationStrategy(String token) {
        this.token = token;
    }

    @Override
    public void authorize(IRequest request) {
        request.setProperty("Authorization", String.format("%s %s", "Bearer", this.token));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void accept(IAuthorizationStrategyVisitor visitor) {
        visitor.visit(this);
    }
}

