/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.capability.resources;

import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.model.IPod;

public interface IRSyncable
extends IBinaryCapability {
    public void sync(Peer var1, Peer var2);

    public void stop();

    public static abstract class Peer {
        private String location;

        private Peer(String location) {
            this.location = location;
        }

        public String getParameter() {
            return this.location;
        }

        public String getLocation() {
            return this.getParameter();
        }

        public abstract boolean isPod();
    }

    public static class LocalPeer
    extends Peer {
        public LocalPeer(String location) {
            super(location);
        }

        @Override
        public boolean isPod() {
            return false;
        }
    }

    public static class PodPeer
    extends Peer {
        private static final char NAMESPACE_POD_SEPARATOR = '/';
        private static final char POD_PATH_SEPARATOR = ':';
        private IPod pod;

        public PodPeer(String location, IPod pod) {
            super(location);
            this.pod = pod;
        }

        @Override
        public String getParameter() {
            return this.pod.getName() + ':' + super.getParameter() + " -n " + this.pod.getNamespace();
        }

        @Override
        public String getLocation() {
            return this.pod.getNamespace() + '/' + this.pod.getName() + ':' + super.getParameter();
        }

        @Override
        public boolean isPod() {
            return true;
        }
    }
}

