/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.Port;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.restclient.model.volume.EmptyDirVolume;
import com.openshift.internal.restclient.model.volume.VolumeMount;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.volume.IVolume;
import com.openshift.restclient.model.volume.IVolumeMount;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;

public class Container
extends ModelNodeAdapter
implements IContainer,
ResourcePropertyKeys {
    private static final String IMAGE = "image";
    private static final String ENV = "env";
    private static final String IMAGE_PULL_POLICY = "imagePullPolicy";
    private static final String LIFECYCLE = "lifecycle";
    private static final String VOLUMEMOUNTS = "volumeMounts";
    private ModelNode node;
    private Map<String, String[]> propertyKeys;

    public Container(ModelNode node) {
        this(node, Collections.emptyMap());
    }

    public Container(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
        this.node = node;
        this.propertyKeys = propertyKeys;
    }

    @Override
    public void setName(String name) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, "name", name);
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.node, this.propertyKeys, "name");
    }

    @Override
    public void setImage(DockerImageURI tag) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, IMAGE, tag.getUriWithoutHost());
    }

    @Override
    public DockerImageURI getImage() {
        return new DockerImageURI(JBossDmrExtentions.asString(this.node, this.propertyKeys, IMAGE));
    }

    @Override
    public void setEnvVars(Map<String, String> vars) {
        if (!vars.isEmpty()) {
            ModelNode env = JBossDmrExtentions.get(this.node, this.propertyKeys, ENV);
            env.clear();
            for (Map.Entry<String, String> var : vars.entrySet()) {
                this.addEnvVar(var.getKey(), var.getValue());
            }
        }
    }

    @Override
    public Map<String, String> getEnvVars() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ModelNode env = JBossDmrExtentions.get(this.node, this.propertyKeys, ENV);
        if (env.isDefined()) {
            for (ModelNode var : env.asList()) {
                hashMap.put(JBossDmrExtentions.asString(var, this.propertyKeys, "name"), JBossDmrExtentions.asString(var, this.propertyKeys, "value"));
            }
        }
        return hashMap;
    }

    @Override
    public void addEnvVar(String key, String value) {
        ModelNode env = JBossDmrExtentions.get(this.node, this.propertyKeys, ENV);
        ModelNode varNode = new ModelNode();
        varNode.get("name").set(key);
        varNode.get("value").set(value);
        env.add(varNode);
    }

    @Override
    public void setPorts(Set<IPort> ports) {
        ModelNode nodePorts = JBossDmrExtentions.get(this.node, this.propertyKeys, "ports");
        nodePorts.clear();
        for (IPort port : ports) {
            ModelNode portNode = nodePorts.add();
            new Port(portNode, port);
        }
    }

    @Override
    public Set<IPort> getPorts() {
        ModelNode nodePorts = JBossDmrExtentions.get(this.node, this.propertyKeys, "ports");
        HashSet<IPort> ports = new HashSet<IPort>();
        if (nodePorts.isDefined()) {
            for (ModelNode port : nodePorts.asList()) {
                ports.add(new Port(port));
            }
        }
        return ports;
    }

    @Override
    public void setImagePullPolicy(String policy) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, IMAGE_PULL_POLICY, policy);
    }

    @Override
    public String getImagePullPolicy() {
        return JBossDmrExtentions.asString(this.node, this.propertyKeys, IMAGE_PULL_POLICY);
    }

    @Override
    public void setLifecycle(String lifecycle) {
        JBossDmrExtentions.set(this.node, this.propertyKeys, LIFECYCLE, lifecycle);
    }

    @Override
    public String getLifecycle() {
        return JBossDmrExtentions.asString(this.node, this.propertyKeys, LIFECYCLE);
    }

    @Override
    public void setVolumes(Set<IVolume> volumes) {
        ModelNode mounts = JBossDmrExtentions.get(this.node, this.propertyKeys, VOLUMEMOUNTS);
        mounts.clear();
        for (IVolume volume : volumes) {
            new EmptyDirVolume(mounts.add(), volume);
        }
    }

    @Override
    public Set<IVolume> getVolumes() {
        HashSet<IVolume> volumes = new HashSet<IVolume>();
        ModelNode mounts = JBossDmrExtentions.get(this.node, this.propertyKeys, VOLUMEMOUNTS);
        if (mounts.isDefined()) {
            for (ModelNode node : mounts.asList()) {
                volumes.add(new VolumeMount(node));
            }
        }
        return volumes;
    }

    @Override
    public void setVolumeMounts(Set<IVolumeMount> volumes) {
        ModelNode mounts = JBossDmrExtentions.get(this.node, this.propertyKeys, VOLUMEMOUNTS);
        mounts.clear();
        for (IVolumeMount volume : volumes) {
            new VolumeMount(mounts.add(), volume);
        }
    }

    @Override
    public Set<IVolumeMount> getVolumeMounts() {
        HashSet<IVolumeMount> volumes = new HashSet<IVolumeMount>();
        ModelNode mounts = JBossDmrExtentions.get(this.node, this.propertyKeys, VOLUMEMOUNTS);
        if (mounts.isDefined()) {
            for (ModelNode node : mounts.asList()) {
                volumes.add(new VolumeMount(node));
            }
        }
        return volumes;
    }

    @Override
    public String toJSONString() {
        return super.toJson(false);
    }
}

