/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.authorization;

import com.openshift.restclient.authorization.BasicAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationStrategyVisitor;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;

public class OpenShiftCredentialsProvider
implements CredentialsProvider,
IAuthorizationStrategyVisitor {
    private CredentialsProvider provider = new SystemDefaultCredentialsProvider();
    private Map<String, Credentials> creds = new HashMap<String, Credentials>(2);
    private String token;
    private String scheme;

    public String getToken() {
        return this.token;
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void visit(BasicAuthorizationStrategy strategy) {
        this.creds.put("Basic".toLowerCase(), (Credentials)new UsernamePasswordCredentials(strategy.getUsername(), strategy.getPassword()));
        this.scheme = "Basic";
        this.token = strategy.getToken();
    }

    @Override
    public void visit(TokenAuthorizationStrategy strategy) {
        this.scheme = "OAuth";
        this.token = strategy.getToken();
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.provider.setCredentials(authscope, credentials);
    }

    public Credentials getCredentials(AuthScope authscope) {
        String scheme = authscope.getScheme().toLowerCase();
        if (this.creds.containsKey(scheme)) {
            return this.creds.get(scheme);
        }
        return this.provider.getCredentials(authscope);
    }

    public void clear() {
        this.provider.clear();
    }
}

