/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.authorization;

import com.openshift.restclient.authorization.AbstractAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationStrategyVisitor;
import com.openshift.restclient.authorization.IRequest;
import com.openshift.restclient.utils.Base64Coder;

public class BasicAuthorizationStrategy
extends AbstractAuthorizationStrategy {
    private final String password;
    private final String token;

    public BasicAuthorizationStrategy(String username, String password, String token) {
        super(username);
        this.password = password;
        this.token = token;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void authorize(IRequest request) {
        String value = "Basic " + Base64Coder.encode(String.format("%s:%s", this.getUsername(), this.password));
        request.setProperty("Authorization", value);
    }

    @Override
    public void accept(IAuthorizationStrategyVisitor visitor) {
        visitor.visit(this);
    }
}

