/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.model.Container;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.Port;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IContainer;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class Pod
extends KubernetesResource
implements IPod {
    private static final String POD_IP = "status.podIP";
    private static final String POD_HOST = "status.hostIP";
    private static final String POD_STATUS = "status.phase";
    private static final String POD_CONTAINERS = "spec.containers";

    public Pod(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        CapabilityInitializer.initializeCapabilities(this.getModifiableCapabilities(), this, client);
    }

    @Override
    public String getIP() {
        return this.asString(POD_IP);
    }

    @Override
    public String getHost() {
        return this.asString(POD_HOST);
    }

    @Override
    public Collection<String> getImages() {
        ArrayList<String> images = new ArrayList<String>();
        ModelNode node = this.get(POD_CONTAINERS);
        if (node.getType() != ModelType.LIST) {
            return images;
        }
        for (ModelNode entry : node.asList()) {
            images.add(entry.get("image").asString());
        }
        return images;
    }

    @Override
    public String getStatus() {
        return this.asString(POD_STATUS);
    }

    @Override
    public Set<IPort> getContainerPorts() {
        HashSet<Port> ports = new HashSet<Port>();
        ModelNode node = this.get(POD_CONTAINERS);
        if (node.getType() == ModelType.LIST) {
            for (ModelNode container : node.asList()) {
                ModelNode containerPorts = container.get(this.getPath("ports"));
                if (containerPorts.getType() != ModelType.LIST) continue;
                for (ModelNode portNode : containerPorts.asList()) {
                    ports.add(new Port(portNode));
                }
            }
        }
        return Collections.unmodifiableSet(ports);
    }

    @Override
    public IContainer addContainer(String name) {
        ModelNode containers = this.get(POD_CONTAINERS);
        Container container = new Container(containers.add());
        container.setName(name);
        return container;
    }

    @Override
    public Collection<IContainer> getContainers() {
        ModelNode containers = this.get(POD_CONTAINERS);
        if (containers.isDefined() && ModelType.LIST == containers.getType()) {
            return containers.asList().stream().map(n -> new Container((ModelNode)n, this.getPropertyKeys())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

