/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IRSyncable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftBinaryRSync
extends AbstractOpenShiftBinaryCapability
implements IRSyncable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftBinaryRSync.class);
    private static final long WAIT_FOR_EXIT_TIMEOUT = 5L;
    private IRSyncable.Peer source;
    private IRSyncable.Peer destination;
    private final Executor executor = Executors.newCachedThreadPool();

    public OpenShiftBinaryRSync(IClient client) {
        super(client);
    }

    @Override
    public InputStream sync(IRSyncable.Peer source, IRSyncable.Peer destination, IBinaryCapability.OpenShiftBinaryOption ... options) throws OpenShiftException {
        this.source = source;
        this.destination = destination;
        this.start(options);
        this.executor.execute(() -> {
            try {
                this.getProcess().waitFor();
            }
            catch (InterruptedException e) {
                throw new OpenShiftException("Error occurred while waiting for rsync operation to complete", new Object[]{e});
            }
        });
        return this.getProcess().getInputStream();
    }

    @Override
    public boolean isDone() {
        return !this.getProcess().isAlive();
    }

    @Override
    public int exitValue() {
        return this.getProcess().exitValue();
    }

    @Override
    public void await() throws InterruptedException {
        try {
            if (this.getProcess() == null) {
                throw new OpenShiftException("Could not sync %s to %s, no process was launched.", this.destination);
            }
            if (!this.getProcess().waitFor(5L, TimeUnit.MINUTES)) {
                throw new OpenShiftException("Syncing %s to %s did not terminate within %d minutes.", this.source, this.destination, 5L);
            }
            if (this.getProcess().exitValue() != 0) {
                String errorMessage = OpenShiftBinaryRSync.getErrorMessage(this.getProcess().getErrorStream());
                throw new OpenShiftException("Syncing %s to %s failed" + (StringUtil.isBlank((String)errorMessage) ? "" : ": %s"), this.source, this.destination, errorMessage);
            }
        }
        catch (InterruptedException e) {
            throw new OpenShiftException((Throwable)e, "Syncing %s to %s was interrupted.", this.source, this.destination);
        }
    }

    private static String getErrorMessage(InputStream errorStream) {
        try {
            return IOUtils.toString((InputStream)errorStream);
        }
        catch (IOException e) {
            LOG.error("Could not retrieve error message from process", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void cleanup() {
        this.source = null;
        this.destination = null;
    }

    @Override
    protected boolean validate() {
        return this.source != null && this.destination != null && OpenShiftBinaryRSync.hasPodPeer(this.source, this.destination);
    }

    private static boolean hasPodPeer(IRSyncable.Peer source, IRSyncable.Peer destination) {
        return source.isPod() || destination.isPod();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryRSync.class.getSimpleName();
    }

    @Override
    protected String buildArgs(List<IBinaryCapability.OpenShiftBinaryOption> options) {
        StringBuilder argsBuilder = new StringBuilder("rsync ");
        argsBuilder.append(this.getUserFlag()).append(this.getTokenFlag()).append(this.getServerFlag());
        if (options.contains((Object)IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY)) {
            argsBuilder.append(this.getSkipTlsVerifyFlag());
        }
        if (options.contains((Object)IBinaryCapability.OpenShiftBinaryOption.EXCLUDE_GIT_FOLDER)) {
            argsBuilder.append(this.getGitFolderExclusionFlag());
        }
        if (options.contains((Object)IBinaryCapability.OpenShiftBinaryOption.NO_PERMS)) {
            argsBuilder.append(this.getNoPermsFlags());
        }
        argsBuilder.append(this.source.getParameter()).append(" ").append(this.destination.getParameter());
        return argsBuilder.toString();
    }
}

