/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.http;

import com.openshift.internal.restclient.http.Parameter;
import com.openshift.internal.restclient.http.ParameterValue;
import com.openshift.internal.restclient.http.StringParameter;
import com.openshift.restclient.OpenShiftException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParameterValueMap
extends ParameterValue<Map<String, Parameter>> {
    public ParameterValueMap(List<Parameter> parameters) {
        this();
        this.addAll(parameters);
    }

    public ParameterValueMap(Parameter ... parameters) {
        this();
        this.addAll(Arrays.asList(parameters));
    }

    public ParameterValueMap() {
        super(new LinkedHashMap());
    }

    public ParameterValueMap addAll(List<? extends Parameter> parameters) {
        for (Parameter parameter : parameters) {
            this.add(parameter);
        }
        return this;
    }

    public ParameterValueMap add(String name, String value) {
        this.add(new StringParameter(name, value));
        return this;
    }

    public ParameterValueMap add(Parameter parameter) {
        if (((Map)this.getValue()).put(parameter.getName(), parameter) != null) {
            throw new OpenShiftException("Duplicate parameter found. There's already a parameter named {0}", parameter.getName());
        }
        return this;
    }

    public Parameter getParamater(String name) {
        return (Parameter)((Map)this.getValue()).get(name);
    }

    public boolean isEmpty() {
        Map values = (Map)this.getValue();
        return values == null || values.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterValue other = (ParameterValue)obj;
        return !(this.getValue() == null ? other.getValue() != null : !((Map)this.getValue()).equals(other.getValue()));
    }

    @Override
    public String toString() {
        return "ParameterValueMap [values=" + this.getValue() + "]";
    }
}

