/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.authorization;

import com.openshift.internal.restclient.authorization.AuthorizationContext;
import com.openshift.internal.restclient.authorization.AuthorizationDetails;
import com.openshift.internal.restclient.authorization.OpenShiftAuthorizationRedirectStrategy;
import com.openshift.internal.restclient.authorization.OpenShiftCredentialsProvider;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.IAuthorizationClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import com.openshift.restclient.authorization.UnauthorizedException;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationClient
implements IAuthorizationClient {
    private static final Logger LOG = LoggerFactory.getLogger(IAuthorizationClient.class);
    private static final int TIMEOUT = 10000;
    private SSLContext sslContext;
    private X509HostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
    private IClient openshiftClient;

    public AuthorizationClient(IClient client) {
        this.openshiftClient = client;
        this.setSSLCertificateCallback(new NoopSSLCertificateCallback());
    }

    @Override
    public IAuthorizationDetails getAuthorizationDetails(String baseURL) {
        try {
            this.getContextUsingCredentials(baseURL, null);
            return new AuthorizationDetails(String.format("%s/oauth/token/request", baseURL));
        }
        catch (UnauthorizedException e) {
            return e.getAuthorizationDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAuthorizationContext getContext(String baseURL) {
        OpenShiftCredentialsProvider credentialsProvider = new OpenShiftCredentialsProvider();
        this.openshiftClient.getAuthorizationStrategy().accept(credentialsProvider);
        IAuthorizationStrategy configuredAuthStrategy = this.openshiftClient.getAuthorizationStrategy();
        try {
            String token = credentialsProvider.getToken();
            this.openshiftClient.setAuthorizationStrategy(new TokenAuthorizationStrategy(token));
            AuthorizationContext authorizationContext = new AuthorizationContext(token, null, this.openshiftClient.getCurrentUser(), credentialsProvider.getScheme());
            return authorizationContext;
        }
        catch (ResourceForbiddenException token) {
        }
        catch (com.openshift.internal.restclient.http.UnauthorizedException | UnauthorizedException e) {
            this.openshiftClient.setAuthorizationStrategy(configuredAuthStrategy);
            IAuthorizationContext iAuthorizationContext = this.getContextUsingCredentials(baseURL, credentialsProvider);
            return iAuthorizationContext;
        }
        finally {
            this.openshiftClient.setAuthorizationStrategy(configuredAuthStrategy);
        }
        return this.getContextUsingCredentials(baseURL, credentialsProvider);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IAuthorizationContext getContextUsingCredentials(String baseURL, CredentialsProvider credentialsProvider) {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            OpenShiftAuthorizationRedirectStrategy redirectStrategy = new OpenShiftAuthorizationRedirectStrategy(this.openshiftClient);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).setConnectionRequestTimeout(10000).setStaleConnectionCheckEnabled(true).build();
            client = HttpClients.custom().setRedirectStrategy((RedirectStrategy)redirectStrategy).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).setHostnameVerifier(this.hostnameVerifier).setDefaultCredentialsProvider(credentialsProvider).setSslcontext(this.sslContext).setDefaultRequestConfig(defaultRequestConfig).build();
            HttpGet request = new HttpGet(new URIBuilder(String.format("%s/oauth/authorize", baseURL)).addParameter("response_type", "token").addParameter("client_id", "openshift-challenging-client").build());
            request.addHeader("X-CSRF-Token", "1");
            response = client.execute((HttpUriRequest)request);
            IAuthorizationContext iAuthorizationContext = redirectStrategy.getAuthorizationContext();
            this.close((Closeable)response);
            this.close((Closeable)client);
            return iAuthorizationContext;
        }
        catch (URISyntaxException e) {
            try {
                throw new OpenShiftException((Throwable)e, String.format("Unvalid URI while trying to get an authorization context for server %s", baseURL), new Object[0]);
                catch (ClientProtocolException e2) {
                    throw new OpenShiftException((Throwable)e2, String.format("Client protocol exception while trying to get authorization context for server %s", baseURL), new Object[0]);
                }
                catch (IOException e3) {
                    throw new OpenShiftException((Throwable)e3, String.format("%s while trying to get an authorization context for server %s", e3.getClass().getName(), baseURL), new Object[0]);
                }
            }
            catch (Throwable throwable) {
                this.close((Closeable)response);
                this.close((Closeable)client);
                throw throwable;
            }
        }
    }

    private void close(Closeable closer) {
        if (closer == null) {
            return;
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSSLCertificateCallback(ISSLCertificateCallback callback) {
        X509TrustManager trustManager = null;
        if (callback != null) {
            trustManager = this.createCallbackTrustManager(callback);
        }
        try {
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Could not install trust manager callback", (Throwable)e);
            this.sslContext = null;
        }
        catch (KeyManagementException e) {
            LOG.warn("Could not install trust manager callback", (Throwable)e);
            this.sslContext = null;
        }
    }

    private X509TrustManager createCallbackTrustManager(ISSLCertificateCallback sslAuthorizationCallback) {
        X509TrustManager trustManager = null;
        try {
            trustManager = this.getCurrentTrustManager();
            if (trustManager == null) {
                LOG.warn("Could not install trust manager callback, no trustmanager was found.");
            } else {
                trustManager = new CallbackTrustManager(trustManager, sslAuthorizationCallback);
            }
        }
        catch (GeneralSecurityException e) {
            LOG.warn("Could not install trust manager callback.", (Throwable)e);
        }
        return trustManager;
    }

    private X509TrustManager getCurrentTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManager = (X509TrustManager)trustManager;
            break;
        }
        return x509TrustManager;
    }

    private static class CallbackTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;
        private ISSLCertificateCallback callback;

        private CallbackTrustManager(X509TrustManager currentTrustManager, ISSLCertificateCallback callback) throws NoSuchAlgorithmException, KeyStoreException {
            this.trustManager = currentTrustManager;
            this.callback = callback;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block2: {
                try {
                    this.trustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    if (this.callback.allowCertificate(chain)) break block2;
                    throw e;
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }
}

