/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.ResourceKind;
import com.openshift.restclient.UnsupportedEndpointException;
import com.openshift.restclient.model.IResource;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(URLBuilder.class);
    private String baseUrl;
    private String kind;
    private String name;
    private Map<String, String> params = new HashMap<String, String>();
    private final IApiTypeMapper typeMappings;
    private String apiVersion;
    private String namespace;
    private String subResource;

    URLBuilder(URL baseUrl, IApiTypeMapper typeMappings, IResource resource) {
        this(baseUrl, typeMappings);
        this.resource(resource);
    }

    URLBuilder(URL baseUrl, IApiTypeMapper typeMappings) {
        this.baseUrl = baseUrl.toString().replaceAll("/*$", "");
        this.typeMappings = typeMappings;
    }

    URLBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    URLBuilder namespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            return this;
        }
        this.namespace = namespace;
        return this;
    }

    URLBuilder name(String name) {
        this.name = name;
        return this;
    }

    URLBuilder kind(String kind) {
        if (!ResourceKind.values().contains(kind)) {
            LOG.warn(String.format("There kind '%s' is not recognized by this client; this operation may fail.", kind));
        }
        this.kind = kind;
        return this;
    }

    URLBuilder resource(IResource resource) {
        if (resource == null) {
            return this;
        }
        this.name = resource.getName();
        this.kind(resource.getKind());
        this.namespace(resource.getNamespace());
        return this;
    }

    URLBuilder addParmeter(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    URLBuilder subresource(String value) {
        this.subResource = value;
        return this;
    }

    URL build() {
        StringBuilder url = new StringBuilder(this.baseUrl);
        if (this.kind == null) {
            throw new RuntimeException("Unable to build a URL because the ResourceKind is unknown");
        }
        this.buildWithNamespaceInPath(url);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Built url: %s", url.toString()));
            }
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildWithNamespaceInPath(StringBuilder url) {
        if (!this.typeMappings.isSupported(this.apiVersion, this.kind)) {
            throw new UnsupportedEndpointException("Unable to determine the api endpoint for kind '%s'", this.kind);
        }
        url.append("/");
        IApiTypeMapper.IVersionedApiResource apiResource = this.typeMappings.getEndpointFor(this.apiVersion, this.kind);
        url.append(apiResource.getPrefix()).append("/").append(apiResource.getVersion());
        if (this.namespace == null && apiResource.isNamespaced()) {
            throw new OpenShiftException("The api endpoint for kind '%s' requires a namespace", this.kind);
        }
        if (apiResource.isNamespaced()) {
            url.append("/namespaces/").append(this.namespace);
        }
        url.append("/").append(apiResource.getName());
        if (this.name != null) {
            url.append("/").append(this.name);
        }
        if (StringUtils.isNotBlank((String)this.subResource) && !apiResource.isSupported(this.subResource)) {
            throw new OpenShiftException("The api endpoint for kind '%s' && subresource '%s' is not supported by the cluster", this.kind, this.subResource);
        }
        if (StringUtils.isNotBlank((String)this.subResource)) {
            url.append("/").append(this.subResource);
        }
        url = this.appendParameters(url);
    }

    private StringBuilder appendParameters(StringBuilder url) {
        if (!this.params.isEmpty()) {
            url.append('?');
            Iterator<Map.Entry<String, String>> iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                try {
                    if (StringUtils.isNotBlank((String)entry.getValue())) {
                        url.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    } else {
                        LOG.error("Unable to append parameter: {} since it is blank", (Object)entry.getKey());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                if (!iterator.hasNext()) continue;
                url.append('&');
            }
        }
        return url;
    }

    public URLBuilder watch() {
        this.addParmeter("watch", "true");
        return this;
    }

    public String websocket() {
        String url = this.build().toString();
        url = "wss" + url.substring(url.indexOf(":"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Built url: %s", url));
        }
        return url;
    }
}

