/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.volume;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.volume.IPersistentVolumeClaim;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PersistentVolumeClaim
extends KubernetesResource
implements IPersistentVolumeClaim {
    private static final String PVC_ACCESS_MODES = "spec.accessModes";
    private static final String PVC_REQUESTED_STORAGE = "spec.resources.requests.storage";
    private static final String STATUS_PHASE = "status.phase";

    public PersistentVolumeClaim(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public Set<String> getAccessModes() {
        HashSet<String> modes = new HashSet<String>();
        ModelNode modelNode = this.get(PVC_ACCESS_MODES);
        if (!modelNode.isDefined() || !modelNode.getType().equals((Object)ModelType.LIST)) {
            return modes;
        }
        for (ModelNode node : modelNode.asList()) {
            modes.add(node.asString());
        }
        return modes;
    }

    @Override
    public void setAccessModes(Set<String> accessModes) {
        ModelNode modelNode = this.get(PVC_ACCESS_MODES);
        modelNode.clear();
        accessModes.stream().forEach(arg_0 -> ((ModelNode)modelNode).add(arg_0));
    }

    @Override
    public String getRequestedStorage() {
        return this.asString(PVC_REQUESTED_STORAGE);
    }

    @Override
    public void setRequestedStorage(String requestedStorage) {
        this.set(PVC_REQUESTED_STORAGE, requestedStorage);
    }

    @Override
    public String getStatus() {
        return this.asString(STATUS_PHASE);
    }
}

