/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.volume;

import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.restclient.model.volume.EmptyDirVolumeSource;
import com.openshift.internal.restclient.model.volume.PersistentVolumeClaimVolumeSource;
import com.openshift.internal.restclient.model.volume.SecretVolumeSource;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.model.volume.IVolumeSource;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public abstract class VolumeSource
extends ModelNodeAdapter
implements IVolumeSource,
ResourcePropertyKeys {
    public VolumeSource(ModelNode node) {
        super(node, new HashMap<String, String[]>());
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "name");
    }

    @Override
    public void setName(String name) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), "name", name);
    }

    @Override
    public String toJSONString() {
        if (StringUtils.isBlank((String)this.getName())) {
            throw new IllegalArgumentException("Name of volume source is missing");
        }
        return this.toJson(true);
    }

    public static IVolumeSource create(ModelNode node) {
        if (node.has("emptyDir")) {
            return new EmptyDirVolumeSource(node);
        }
        if (node.has("secret")) {
            return new SecretVolumeSource(node);
        }
        if (node.has("persistentVolumeClaim")) {
            return new PersistentVolumeClaimVolumeSource(node);
        }
        return new VolumeSource(node){};
    }
}

