/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class List
extends KubernetesResource
implements IList {
    private static final String ITEMS = "items";
    private String kind;
    private Collection<IResource> items;

    public List(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
        String listKind = this.asString("kind");
        if (StringUtils.isNotBlank((String)listKind)) {
            this.kind = listKind.substring(0, listKind.length() - "List".length());
        }
    }

    @Override
    public Collection<IResource> getItems() {
        if (this.items == null) {
            String key = this.getNode().has("objects") ? "objects" : ITEMS;
            ModelNode listNode = this.get(key);
            if (listNode.isDefined()) {
                java.util.List nodes = this.get(key).asList();
                this.items = new ArrayList<IResource>(nodes.size());
                IResourceFactory factory = this.getClient().getResourceFactory();
                if (factory != null) {
                    for (ModelNode node : nodes) {
                        if (this.kind != null && !node.get("kind").isDefined()) {
                            this.set(node, "kind", this.kind);
                        }
                        if (!node.get("apiVersion").isDefined()) {
                            this.set(node, "apiVersion", this.getApiVersion());
                        }
                        Object resource = factory.create(node.toJSONString(true));
                        this.items.add((IResource)resource);
                    }
                }
            } else {
                this.items = Collections.emptyList();
            }
        }
        return Collections.unmodifiableCollection(this.items);
    }

    @Override
    public void addAll(Collection<IResource> items) {
        if (this.items == null) {
            this.items = new ArrayList<IResource>();
        }
        ModelNode itemNode = this.get("objects");
        for (IResource resource : items) {
            itemNode.add(ModelNode.fromJSONString((String)resource.toString()));
            this.items.add(resource);
        }
    }
}

