/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.ApiTypeMapper;
import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.authorization.AuthorizationContext;
import com.openshift.internal.restclient.capability.CapabilityInitializer;
import com.openshift.internal.restclient.okhttp.WatchClient;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IOpenShiftWatchListener;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.IWatcher;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.UnsupportedOperationException;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.ICapability;
import com.openshift.restclient.http.IHttpConstants;
import com.openshift.restclient.model.IList;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements IClient,
IHttpConstants {
    public static final String SYSTEM_PROP_K8E_API_VERSION = "osjc.k8e.apiversion";
    public static final String SYSTEM_PROP_OPENSHIFT_API_VERSION = "osjc.openshift.apiversion";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);
    private URL baseUrl;
    private OkHttpClient client;
    private IResourceFactory factory;
    private Map<Class<? extends ICapability>, ICapability> capabilities = new HashMap<Class<? extends ICapability>, ICapability>();
    private boolean capabilitiesInitialized = false;
    private static final String OS_API_ENDPOINT = "oapi";
    private String openShiftVersion;
    private String kubernetesVersion;
    private AuthorizationContext authContext;
    private IApiTypeMapper typeMapper;

    public DefaultClient(URL baseUrl, OkHttpClient client, IResourceFactory factory, IApiTypeMapper typeMapper, AuthorizationContext authContext) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.factory = factory;
        if (this.factory != null) {
            this.factory.setClient(this);
        }
        this.openShiftVersion = System.getProperty(SYSTEM_PROP_OPENSHIFT_API_VERSION, null);
        this.kubernetesVersion = System.getProperty(SYSTEM_PROP_K8E_API_VERSION, null);
        this.typeMapper = typeMapper != null ? typeMapper : new ApiTypeMapper(baseUrl.toString(), client);
        this.authContext = authContext;
    }

    @Override
    public IClient clone() {
        AuthorizationContext context = this.authContext.clone();
        DefaultClient clone = new DefaultClient(this.baseUrl, this.client, this.factory, this.typeMapper, context);
        context.setClient(clone);
        return clone;
    }

    @Override
    public IResourceFactory getResourceFactory() {
        return this.factory;
    }

    @Override
    public IWatcher watch(String namespace, IOpenShiftWatchListener listener, String ... kinds) {
        WatchClient watcher = new WatchClient(this, this.typeMapper, this.client);
        return watcher.watch(Arrays.asList(kinds), namespace, listener);
    }

    @Override
    public String getResourceURI(IResource resource) {
        return new URLBuilder(this.getBaseURL(), this.typeMapper, resource).build().toString();
    }

    @Override
    public <T extends IResource> List<T> list(String kind) {
        return this.list(kind, "");
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace) {
        return this.list(kind, namespace, new HashMap<String, String>());
    }

    @Override
    public <T extends IResource> List<T> list(String kind, String namespace, Map<String, String> labels) {
        IList list = this.get(kind, namespace);
        ArrayList<IResource> items = new ArrayList<IResource>(list.getItems());
        return this.filterItems(items, labels);
    }

    private <T extends IResource> List<T> filterItems(List<T> items, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return items;
        }
        ArrayList<IResource> filtered = new ArrayList<IResource>();
        for (IResource item : items) {
            if (!item.getLabels().entrySet().containsAll(labels.entrySet())) continue;
            filtered.add(item);
        }
        return filtered;
    }

    @Override
    public Collection<IResource> create(IList list, String namespace) {
        ArrayList<IResource> results = new ArrayList<IResource>(list.getItems().size());
        for (IResource resource : list.getItems()) {
            try {
                results.add(this.create(resource, namespace));
            }
            catch (OpenShiftException e) {
                if (e.getStatus() != null) {
                    results.add(e.getStatus());
                    continue;
                }
                throw e;
            }
        }
        return results;
    }

    @Override
    public <T extends IResource> T create(T resource) {
        return this.create(resource, resource.getNamespace());
    }

    @Override
    public <T extends IResource> T create(T resource, String namespace) {
        return this.execute(HttpMethod.POST, resource.getKind(), namespace, null, null, resource);
    }

    @Override
    public <T extends IResource> T create(String kind, String namespace, String name, String subresource, IResource payload) {
        return this.execute(HttpMethod.POST, kind, namespace, name, subresource, payload);
    }

    private <T extends IResource> T execute(HttpMethod method, String kind, String namespace, String name, String subresource, IResource payload) {
        return this.execute(method.toString(), kind, namespace, name, subresource, payload);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends IResource> T execute(String method, String kind, String namespace, String name, String subresource, IResource payload) {
        if ("List".equals(kind)) {
            throw new UnsupportedOperationException("Generic create operation not supported for resource type 'List'");
        }
        URL endpoint = new URLBuilder(this.baseUrl, this.typeMapper).kind(kind).name(name).namespace(namespace).subresource(subresource).build();
        try {
            Request request = this.newRequestBuilderTo(endpoint.toString()).method(method, this.getPayload(method, payload)).build();
            LOGGER.debug("About to make {} request: {}", (Object)request.method(), (Object)request);
            try (Response result = this.client.newCall(request).execute();){
                String response = result.body().string();
                LOGGER.debug("Response: {}", (Object)response);
                Object t = this.factory.create(response);
                return t;
            }
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, "Unable to execute request to %s", endpoint);
        }
    }

    private RequestBody getPayload(String method, IResource payload) {
        switch (method.toUpperCase()) {
            case "GET": 
            case "DELETE": {
                return null;
            }
        }
        String json = payload == null ? "" : payload.toJson(true);
        LOGGER.debug("About to send payload: {}", (Object)json);
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getServerReadyStatus() {
        try {
            Request request = new Request.Builder().url(new URL(this.baseUrl, "healthz/ready")).header("Accept", "*/*").build();
            try (Response response = this.client.newCall(request).execute();){
                String string = response.body().string();
                return string;
            }
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, "Exception while trying to determine the health/ready response of the server", new Object[0]);
        }
    }

    public Request.Builder newRequestBuilderTo(String endpoint) {
        Request.Builder builder = new Request.Builder().url(endpoint.toString()).header("Accept", "application/json");
        String token = null;
        if (this.authContext != null && StringUtils.isNotBlank((String)this.authContext.getToken())) {
            token = this.authContext.getToken();
        }
        builder.header("Authorization", String.format("%s %s", "Bearer", token));
        return builder;
    }

    @Override
    public <T extends IResource> T update(T resource) {
        return this.execute(HttpMethod.PUT, resource.getKind(), resource.getNamespace(), resource.getName(), null, resource);
    }

    @Override
    public <T extends IResource> void delete(T resource) {
        this.execute(HttpMethod.DELETE, resource.getKind(), resource.getNamespace(), resource.getName(), null, resource);
    }

    @Override
    public IList get(String kind, String namespace) {
        return (IList)this.execute(HttpMethod.GET, kind, namespace, null, null, null);
    }

    @Override
    public <T extends IResource> T get(String kind, String name, String namespace) {
        return this.execute(HttpMethod.GET, kind, namespace, name, null, null);
    }

    public synchronized void initializeCapabilities() {
        if (this.capabilitiesInitialized) {
            return;
        }
        CapabilityInitializer.initializeClientCapabilities(this.capabilities, this);
        this.capabilitiesInitialized = true;
    }

    @Override
    public <T extends ICapability> T getCapability(Class<T> capability) {
        return (T)this.capabilities.get(capability);
    }

    @Override
    public boolean supports(Class<? extends ICapability> capability) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        return this.capabilities.containsKey(capability);
    }

    @Override
    public <T extends ICapability, R> R accept(CapabilityVisitor<T, R> visitor, R unsupportedCapabililityValue) {
        if (!this.capabilitiesInitialized) {
            this.initializeCapabilities();
        }
        if (this.capabilities.containsKey(visitor.getCapabilityType())) {
            ICapability capability = this.capabilities.get(visitor.getCapabilityType());
            return visitor.visit(capability);
        }
        return unsupportedCapabililityValue;
    }

    @Override
    public String getOpenShiftAPIVersion() {
        return this.typeMapper.getPreferedVersionFor(OS_API_ENDPOINT);
    }

    @Override
    public URL getBaseURL() {
        return this.baseUrl;
    }

    @Override
    public IAuthorizationContext getAuthorizationContext() {
        return this.authContext;
    }

    public void setToken(String token) {
        this.authContext.setToken(token);
    }

    public String getToken() {
        return this.getAuthorizationContext().getToken();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.toString().hashCode());
        result = 31 * result + (this.kubernetesVersion == null ? 0 : this.kubernetesVersion.hashCode());
        result = 31 * result + (this.openShiftVersion == null ? 0 : this.openShiftVersion.hashCode());
        result = 31 * result + (this.authContext == null || this.authContext.getToken() == null ? 0 : this.authContext.getToken().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultClient)) {
            return false;
        }
        DefaultClient other = (DefaultClient)obj;
        if (this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.toString().equals(other.baseUrl.toString())) {
            return false;
        }
        if (this.kubernetesVersion == null ? other.kubernetesVersion != null : !this.kubernetesVersion.equals(other.kubernetesVersion)) {
            return false;
        }
        if (this.openShiftVersion == null ? other.openShiftVersion != null : !this.openShiftVersion.equals(other.openShiftVersion)) {
            return false;
        }
        if (this.authContext == null) {
            return other.authContext == null;
        }
        if (other.authContext == null) {
            return false;
        }
        return ObjectUtils.equals((Object)this.authContext.getUserName(), (Object)other.authContext.getUserName());
    }

    @Override
    public <T> T adapt(Class<T> klass) {
        if (DefaultClient.class.equals(klass)) {
            return (T)this;
        }
        if (OkHttpClient.class.equals(klass)) {
            return (T)this.client;
        }
        if (IApiTypeMapper.class.equals(klass)) {
            return (T)this.typeMapper;
        }
        if (ICapability.class.isAssignableFrom(klass) && this.supports(klass)) {
            return this.getCapability(klass);
        }
        return null;
    }

    static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

