/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.images;

public class DockerImageURI {
    public static final String LATEST = "latest";
    private String registryHost;
    private String userName;
    private String name;
    private String tag;

    public DockerImageURI(String registryHost, String userName, String name) {
        this(registryHost, userName, name, LATEST);
    }

    public DockerImageURI(String registryHost, String userName, String name, String imageTag) {
        this.registryHost = registryHost;
        this.userName = userName;
        this.name = name;
        this.tag = imageTag;
    }

    public DockerImageURI(String tag) {
        if (tag != null) {
            String[] segments = tag.split("/");
            switch (segments.length) {
                case 3: {
                    this.registryHost = segments[0];
                    this.userName = segments[1];
                    this.setNameAndTag(segments[2]);
                    break;
                }
                case 2: {
                    this.userName = segments[0];
                    this.setNameAndTag(segments[1]);
                    break;
                }
                default: {
                    this.setNameAndTag(segments[0]);
                }
            }
        }
    }

    private void setNameAndTag(String nameAndTag) {
        String[] nameTag = nameAndTag.split(":");
        if (nameTag.length == 2) {
            this.name = nameTag[0];
            this.tag = nameTag[1];
        } else {
            this.name = nameTag[0];
            this.tag = LATEST;
        }
    }

    public String toString() {
        return this.getAbsoluteUri();
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRepositoryHost() {
        return this.registryHost;
    }

    public String getAbsoluteUri() {
        return this.buildUri(this.registryHost, this.userName, this.name, this.tag);
    }

    public String getBaseUri() {
        return this.buildUri(null, this.userName, this.name, this.tag);
    }

    public String getUriUserNameAndName() {
        return this.buildUri(null, this.userName, this.name, null);
    }

    public String getUriWithoutTag() {
        return this.buildUri(this.registryHost, this.userName, this.name, null);
    }

    public String getUriWithoutHost() {
        return this.buildUri(null, this.userName, this.name, this.tag);
    }

    public String getNameAndTag() {
        return this.buildUri(null, null, this.name, this.tag);
    }

    private String buildUri(String host, String user, String name, String tag) {
        StringBuilder b = new StringBuilder();
        if (host != null) {
            b.append(host).append("/");
        }
        if (user != null) {
            b.append(user).append("/");
        }
        b.append(name);
        if (tag != null) {
            b.append(":").append(tag);
        }
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.registryHost == null ? 0 : this.registryHost.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerImageURI other = (DockerImageURI)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.registryHost == null ? other.registryHost != null : !this.registryHost.equals(other.registryHost)) {
            return false;
        }
        if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

