/*******************************************************************************
 * Copyright (c) 2015 Red Hat, Inc. Distributed under license by Red Hat, Inc.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Red Hat, Inc.
 ******************************************************************************/
package com.openshift.internal.restclient.capability.server;

import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ResourceKind;
import com.openshift.restclient.capability.server.ITemplateProcessing;
import com.openshift.restclient.model.template.ITemplate;

/**
 * @author Jeff Cantrill
 */
public class ServerTemplateProcessing implements ITemplateProcessing {

	private IClient client;

	public ServerTemplateProcessing(IClient client){
		this.client = client;
	}
	
	@Override
	public boolean isSupported() {
		IApiTypeMapper mapper = client.adapt(IApiTypeMapper.class);
		if(mapper != null) {
			return mapper.isSupported(ResourceKind.PROCESSED_TEMPLATES);
		}
		return false;
	}

	@Override
	public String getName() {
		return this.getClass().getSimpleName();
	}

	@Override
	public ITemplate process(ITemplate template, String namespace) {
		return client.execute("POST", ResourceKind.PROCESSED_TEMPLATES, namespace, null, null, template);

	}
	
}
