/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.model.IPort;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class Port
implements IPort {
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_PROTOCOL = "protocol";
    private static final String PROPERTY_CONTAINER_PORT = "containerPort";
    private static final Map<String, String[]> KEY_MAP = new HashMap<String, String[]>();
    private ModelNode node;

    public Port(ModelNode node) {
        this.node = node;
    }

    public Port(ModelNode node, IPort port) {
        this(node);
        if (StringUtils.isNotEmpty((String)port.getName())) {
            this.setName(port.getName());
        }
        this.setProtocol(port.getProtocol());
        this.setContainerPort(port.getContainerPort());
    }

    public ModelNode getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.node, KEY_MAP, PROPERTY_NAME);
    }

    public void setName(String name) {
        JBossDmrExtentions.set(this.node, KEY_MAP, PROPERTY_NAME, name);
    }

    public void setContainerPort(int port) {
        JBossDmrExtentions.set(this.node, KEY_MAP, PROPERTY_CONTAINER_PORT, port);
    }

    @Override
    public int getContainerPort() {
        return JBossDmrExtentions.asInt(this.node, KEY_MAP, PROPERTY_CONTAINER_PORT);
    }

    public void setProtocol(String name) {
        JBossDmrExtentions.set(this.node, KEY_MAP, PROPERTY_PROTOCOL, name);
    }

    @Override
    public String getProtocol() {
        return JBossDmrExtentions.asString(this.node, KEY_MAP, PROPERTY_PROTOCOL);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getContainerPort();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Port other = (Port)obj;
        if (this.getContainerPort() != other.getContainerPort()) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getProtocol() == null ? other.getProtocol() != null : !this.getProtocol().equals(other.getProtocol()));
    }

    static {
        KEY_MAP.put(PROPERTY_NAME, new String[]{PROPERTY_NAME});
        KEY_MAP.put(PROPERTY_PROTOCOL, new String[]{PROPERTY_PROTOCOL});
        KEY_MAP.put(PROPERTY_CONTAINER_PORT, new String[]{PROPERTY_CONTAINER_PORT});
    }
}

