/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPodLogRetrieval;
import com.openshift.restclient.model.IPod;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftBinaryPodLogRetrieval
implements IPodLogRetrieval {
    private static final Logger LOG = LoggerFactory.getLogger(IPodLogRetrieval.class);
    private IPod pod;
    private IClient client;
    private Map<String, PodLogs> cache = new HashMap<String, PodLogs>();

    public OpenShiftBinaryPodLogRetrieval(IPod pod, IClient client) {
        this.pod = pod;
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPodLogRetrieval.class.getSimpleName();
    }

    @Override
    public InputStream getLogs(boolean follow, IBinaryCapability.OpenShiftBinaryOption ... options) {
        return this.getLogs(follow, (String)null, options);
    }

    @Override
    public InputStream getLogs(boolean follow, String container, IBinaryCapability.OpenShiftBinaryOption ... options) {
        String normalizedContainer = StringUtils.defaultIfBlank((String)container, (String)"");
        Map<String, PodLogs> map = this.cache;
        synchronized (map) {
            InputStream inputStream;
            block10: {
                if (this.cache.containsKey(normalizedContainer)) {
                    return this.cache.get(normalizedContainer).getLogs();
                }
                PodLogs logs = null;
                try {
                    logs = new PodLogs(this.client, follow, normalizedContainer, options);
                    inputStream = logs.getLogs();
                    if (logs == null) break block10;
                    this.cache.put(normalizedContainer, logs);
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (logs != null) {
                            this.cache.put(normalizedContainer, logs);
                        }
                        throw throwable;
                    }
                }
            }
            return inputStream;
        }
    }

    @Override
    public void stop() {
        new ArrayList<String>(this.cache.keySet()).forEach(c -> this.stop((String)c));
    }

    @Override
    public synchronized void stop(String container) {
        if (!this.cache.containsKey(container)) {
            return;
        }
        try {
            PodLogs logs = this.cache.remove(container);
            logs.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop pod logs", (Throwable)e);
        }
    }

    private class PodLogs
    extends AbstractOpenShiftBinaryCapability {
        private String container;
        private boolean follow;
        private SequenceInputStream is;
        private IBinaryCapability.OpenShiftBinaryOption[] options;

        PodLogs(IClient client, boolean follow, String container, IBinaryCapability.OpenShiftBinaryOption ... options) {
            super(client);
            this.follow = follow;
            this.container = container;
            this.options = options;
        }

        public synchronized InputStream getLogs() {
            if (this.is == null) {
                this.start(this.options);
                this.is = new SequenceInputStream(this.getProcess().getInputStream(), this.getProcess().getErrorStream());
            }
            return this.is;
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public String getName() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cleanup() {
            this.follow = false;
            if (this.getProcess() != null) {
                IOUtils.closeQuietly((InputStream)this.getProcess().getInputStream());
                IOUtils.closeQuietly((InputStream)this.getProcess().getErrorStream());
            }
            Map map = OpenShiftBinaryPodLogRetrieval.this.cache;
            synchronized (map) {
                OpenShiftBinaryPodLogRetrieval.this.cache.remove(this.container);
            }
        }

        @Override
        protected boolean validate() {
            return true;
        }

        @Override
        protected String buildArgs(List<IBinaryCapability.OpenShiftBinaryOption> options) {
            StringBuilder argsBuilder = new StringBuilder();
            argsBuilder.append("logs ");
            if (options.contains((Object)IBinaryCapability.OpenShiftBinaryOption.SKIP_TLS_VERIFY)) {
                argsBuilder.append(this.getSkipTlsVerifyFlag());
            }
            argsBuilder.append(this.getServerFlag()).append(" ").append(OpenShiftBinaryPodLogRetrieval.this.pod.getName()).append(" ").append("-n ").append(OpenShiftBinaryPodLogRetrieval.this.pod.getNamespace()).append(" ").append(this.getTokenFlag());
            if (this.follow) {
                argsBuilder.append(" -f ");
            }
            if (StringUtils.isNotBlank((String)this.container)) {
                argsBuilder.append(" -c ").append(this.container);
            }
            return argsBuilder.toString();
        }
    }
}

