/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.route.IRoute;
import com.openshift.restclient.model.route.ITLSConfig;
import com.openshift.restclient.model.route.ITargetPort;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Route
extends KubernetesResource
implements IRoute {
    private static final String ROUTE_HOST = "spec.host";
    private static final String ROUTE_PATH = "spec.path";
    private static final String ROUTE_KIND = "spec.to.kind";
    private static final String ROUTE_SERVICE_NAME = "spec.to.name";
    private static final String ROUTE_TLS = "spec.tls";
    private static final String ROUTE_TLS_TERMINATION_TYPE = "spec.tls.termination";
    private static final String ROUTE_TLS_CERTIFICATE = "spec.tls.certificate";
    private static final String ROUTE_TLS_KEY = "spec.tls.key";
    private static final String ROUTE_TLS_CACERT = "spec.tls.caCertificate";
    private static final String ROUTE_TLS_DESTINATION_CACERT = "spec.tls.destinationCACertificate";
    private static final String ROUTE_PORT = "spec.port";
    private static final String ROUTE_PORT_TARGETPORT = "spec.port.targetPort";

    public Route(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public String getHost() {
        return this.asString(ROUTE_HOST);
    }

    @Override
    public void setHost(String host) {
        this.get(ROUTE_HOST).set(host);
    }

    @Override
    public String getPath() {
        return this.asString(ROUTE_PATH);
    }

    @Override
    public void setPath(String path) {
        this.get(ROUTE_PATH).set(path);
    }

    @Override
    public String getServiceName() {
        return this.asString(ROUTE_SERVICE_NAME);
    }

    @Override
    public void setServiceName(String serviceName) {
        this.get(ROUTE_SERVICE_NAME).set(serviceName);
        this.get(ROUTE_KIND).set("Service");
    }

    @Override
    public ITLSConfig getTLSConfig() {
        if (this.get(ROUTE_TLS).isDefined()) {
            return new TLSConfig();
        }
        return null;
    }

    @Override
    public ITLSConfig createTLSConfig() {
        ITLSConfig config = this.getTLSConfig();
        if (config == null) {
            this.get(ROUTE_TLS).set(new ModelNode());
            config = new TLSConfig();
        }
        return config;
    }

    @Override
    public ITargetPort getPort() {
        if (this.get(ROUTE_PORT).isDefined()) {
            return new TargetPort();
        }
        return null;
    }

    @Override
    public ITargetPort createPort() {
        ITargetPort targetPort = this.getPort();
        if (targetPort == null) {
            this.get(ROUTE_PORT).set(new ModelNode());
            targetPort = new TargetPort();
        }
        return targetPort;
    }

    @Override
    public String getURL() {
        String scheme = this.getTLSConfig() == null ? "http" : "https";
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.format("%s://%s%s", scheme, this.getHost(), path);
    }

    private class TargetPort
    implements ITargetPort {
        private TargetPort() {
        }

        @Override
        public String getTargetPortName() {
            return Route.this.asString(Route.ROUTE_PORT_TARGETPORT);
        }

        @Override
        public void setTargetPortName(String portName) {
            Route.this.get(Route.ROUTE_PORT_TARGETPORT).set(portName);
        }

        @Override
        public Integer getTargetPort() {
            if (Route.this.has(Route.ROUTE_PORT_TARGETPORT)) {
                return Route.this.asInt(Route.ROUTE_PORT_TARGETPORT);
            }
            return -1;
        }

        @Override
        public void setTargetPort(Integer port) {
            Route.this.get(Route.ROUTE_PORT_TARGETPORT).set(port.intValue());
        }
    }

    private class TLSConfig
    implements ITLSConfig {
        private TLSConfig() {
        }

        @Override
        public String getTerminationType() {
            return Route.this.asString(Route.ROUTE_TLS_TERMINATION_TYPE);
        }

        @Override
        public void setTerminationType(String type) {
            Route.this.get(Route.ROUTE_TLS_TERMINATION_TYPE).set(type);
        }

        @Override
        public String getCertificate() {
            return Route.this.asString(Route.ROUTE_TLS_CERTIFICATE);
        }

        @Override
        public void setCertificate(String certificate) {
            Route.this.get(Route.ROUTE_TLS_CERTIFICATE).set(certificate);
        }

        @Override
        public String getKey() {
            return Route.this.asString(Route.ROUTE_TLS_KEY);
        }

        @Override
        public void setKey(String key) {
            Route.this.get(Route.ROUTE_TLS_KEY).set(key);
        }

        @Override
        public String getCACertificate() {
            return Route.this.asString(Route.ROUTE_TLS_CACERT);
        }

        @Override
        public void setCACertificate(String caCertificate) {
            Route.this.get(Route.ROUTE_TLS_CACERT).set(caCertificate);
        }

        @Override
        public String getDestinationCertificate() {
            return Route.this.asString(Route.ROUTE_TLS_DESTINATION_CACERT);
        }

        @Override
        public void setDestinationCertificate(String destinationCertificate) {
            Route.this.get(Route.ROUTE_TLS_DESTINATION_CACERT).set(destinationCertificate);
        }
    }
}

