/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.ResourceFactory;
import com.openshift.internal.restclient.authorization.AuthorizationContext;
import com.openshift.internal.restclient.okhttp.OpenShiftAuthenticator;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.utils.SSLUtils;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class ClientBuilder {
    private String baseUrl;
    private ISSLCertificateCallback sslCertificateCallback = new NoopSSLCertificateCallback();
    private boolean sslCertCallbackWithDefaultHostnameVerifier = false;
    private X509Certificate certificate;
    private Collection<X509Certificate> certificateCollection;
    private String certificateAlias;
    private IResourceFactory resourceFactory;
    private String userName;
    private String token;
    private String password;
    private Authenticator proxyAuthenticator;
    private int maxRequests = 64;
    private int maxRequestsPerHost = 10;
    private int readTimeout = 120000;
    private TimeUnit readTimeoutUnit = TimeUnit.MILLISECONDS;
    private int connectTimeout = 120000;
    private TimeUnit connectTimeoutUnit = TimeUnit.MILLISECONDS;
    private int writeTimeout = 120000;
    private TimeUnit writeTimeoutUnit = TimeUnit.MILLISECONDS;

    public ClientBuilder() {
        this(null);
    }

    public ClientBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ClientBuilder sslCertificateCallback(ISSLCertificateCallback callback) {
        this.sslCertificateCallback = callback == null ? new NoopSSLCertificateCallback() : callback;
        return this;
    }

    public ClientBuilder sslCertCallbackWithDefaultHostnameVerifier(boolean b) {
        this.sslCertCallbackWithDefaultHostnameVerifier = b;
        return this;
    }

    public ClientBuilder sslCertificate(String alias, X509Certificate cert) {
        this.certificateAlias = alias;
        this.certificate = cert;
        return this;
    }

    public ClientBuilder sslCertificateCollection(String alias, Collection<X509Certificate> certs) {
        this.certificateAlias = alias;
        this.certificateCollection = certs;
        return this;
    }

    public ClientBuilder resourceFactory(IResourceFactory factory) {
        this.resourceFactory = factory;
        return this;
    }

    public ClientBuilder toCluster(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ClientBuilder withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public ClientBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public ClientBuilder usingToken(String token) {
        this.token = token;
        return this;
    }

    public ClientBuilder withConnectTimeout(int timeout, TimeUnit unit) {
        this.connectTimeout = timeout;
        this.connectTimeoutUnit = unit;
        return this;
    }

    public ClientBuilder withReadTimeout(int timeout, TimeUnit unit) {
        this.readTimeout = timeout;
        this.readTimeoutUnit = unit;
        return this;
    }

    public ClientBuilder withWriteTimeout(int timeout, TimeUnit unit) {
        this.writeTimeout = timeout;
        this.writeTimeoutUnit = unit;
        return this;
    }

    public ClientBuilder proxyAuthenticator(Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        return this;
    }

    public ClientBuilder withConnectTimeout(int connectInMillis) {
        this.connectTimeout = connectInMillis;
        return this;
    }

    public ClientBuilder withMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
        return this;
    }

    public ClientBuilder withMaxRequestsPerHost(int maxRequestsPerHost) {
        this.maxRequestsPerHost = maxRequestsPerHost;
        return this;
    }

    public IClient build() {
        try {
            TrustManagerFactory trustManagerFactory = this.initTrustManagerFactory(this.certificateAlias, this.certificate, this.certificateCollection);
            X509TrustManager trustManager = this.getCurrentTrustManager(trustManagerFactory);
            SSLContext sslContext = SSLUtils.getSSLContext(trustManager);
            ResponseCodeInterceptor responseCodeInterceptor = new ResponseCodeInterceptor();
            OpenShiftAuthenticator authenticator = new OpenShiftAuthenticator();
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(this.maxRequests);
            dispatcher.setMaxRequestsPerHost(this.maxRequestsPerHost);
            OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)responseCodeInterceptor).authenticator((Authenticator)authenticator).dispatcher(dispatcher).readTimeout((long)this.readTimeout, this.readTimeoutUnit).writeTimeout((long)this.writeTimeout, this.writeTimeoutUnit).connectTimeout((long)this.connectTimeout, this.connectTimeoutUnit).sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            if (!this.sslCertCallbackWithDefaultHostnameVerifier) {
                builder.hostnameVerifier((HostnameVerifier)this.sslCertificateCallback);
            }
            if (this.proxyAuthenticator != null) {
                builder.proxyAuthenticator(this.proxyAuthenticator);
            }
            OkHttpClient okClient = builder.build();
            IResourceFactory factory = this.defaultIfNull(this.resourceFactory, new ResourceFactory(null));
            AuthorizationContext authContext = new AuthorizationContext(this.token, this.userName, this.password);
            DefaultClient client = new DefaultClient(new URL(this.baseUrl), okClient, factory, null, authContext);
            authContext.setClient(client);
            responseCodeInterceptor.setClient(client);
            authenticator.setClient(client);
            authenticator.setOkClient(okClient);
            return client;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new OpenShiftException((Throwable)e, "Unable to initialize client", new Object[0]);
        }
    }

    private <T> T defaultIfNull(T value, T aDefault) {
        if (value != null) {
            return value;
        }
        return aDefault;
    }

    private X509TrustManager getCurrentTrustManager(TrustManagerFactory trustManagerFactory) throws NoSuchAlgorithmException, KeyStoreException {
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            return new CallbackTrustManager(x509TrustManager, this.sslCertificateCallback);
        }
        return null;
    }

    private TrustManagerFactory initTrustManagerFactory(String alias, X509Certificate cert, Collection<X509Certificate> certs) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (alias != null && (cert != null || certs != null)) {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            if (cert != null) {
                cert.checkValidity();
                ks.setCertificateEntry(alias, cert);
            }
            if (certs != null) {
                int i = 0;
                for (X509Certificate x509 : certs) {
                    x509.checkValidity();
                    ks.setCertificateEntry(alias + i, x509);
                    ++i;
                }
            }
            trustManagerFactory.init(ks);
        } else {
            trustManagerFactory.init((KeyStore)null);
        }
        return trustManagerFactory;
    }

    private static class CallbackTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;
        private ISSLCertificateCallback callback;

        private CallbackTrustManager(X509TrustManager currentTrustManager, ISSLCertificateCallback callback) throws NoSuchAlgorithmException, KeyStoreException {
            this.trustManager = currentTrustManager;
            this.callback = callback;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            block2: {
                try {
                    this.trustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    if (this.callback.allowCertificate(chain)) break block2;
                    throw e;
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkServerTrusted(chain, authType);
        }
    }
}

