/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.KubernetesAPIVersion;
import com.openshift.internal.restclient.OpenShiftAPIVersion;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.ResourceKind;
import com.openshift.restclient.UnsupportedEndpointException;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTypeMapper
implements IApiTypeMapper,
ResourcePropertyKeys {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiTypeMapper.class);
    private final String baseUrl;
    private final OkHttpClient client;
    private List<VersionedApiResource> resourceEndpoints;
    private final Map<String, String> preferedVersion = new HashMap<String, String>(2);
    private boolean initialized = false;

    public ApiTypeMapper(String baseUrl, OkHttpClient client) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.preferedVersion.put("api", KubernetesAPIVersion.v1.toString());
        this.preferedVersion.put("oapi", OpenShiftAPIVersion.v1.toString());
    }

    @Override
    public String getPreferedVersionFor(String endpoint) {
        return this.preferedVersion.get(endpoint);
    }

    @Override
    public boolean isSupported(IResource resource) {
        return this.isSupported(resource.getApiVersion(), resource.getKind());
    }

    @Override
    public IApiTypeMapper.IVersionedApiResource getEndpointFor(String apiVersion, String kind) {
        this.init();
        IApiTypeMapper.IVersionedApiResource apiresource = this.endpointFor(apiVersion, kind);
        if (apiresource == null) {
            throw new UnsupportedEndpointException("No endpoint found for %s, version %s", kind, apiVersion);
        }
        return apiresource;
    }

    private IApiTypeMapper.IVersionedApiResource endpointFor(String version, String kind) {
        int index;
        String[] split = StringUtils.isBlank((String)version) ? new String[]{} : version.split("/");
        Optional<IApiTypeMapper.IVersionedApiResource> result = null;
        result = split.length <= 1 ? Stream.of("api", "oapi").map(api -> this.formatEndpointFor((String)api, split.length == 0 ? this.preferedVersion.get(api) : split[0], kind)).filter(e -> this.resourceEndpoints.contains(e)).findFirst() : Optional.of(this.formatEndpointFor("apis", version, ResourceKind.pluralize(kind, true, true)));
        if (result.isPresent() && (index = this.resourceEndpoints.indexOf(result.get())) > -1) {
            return this.resourceEndpoints.get(index);
        }
        return null;
    }

    @Override
    public boolean isSupported(String kind) {
        return this.isSupported(null, kind);
    }

    @Override
    public boolean isSupported(String version, String kind) {
        this.init();
        return this.endpointFor(version, kind) != null;
    }

    private IApiTypeMapper.IVersionedApiResource formatEndpointFor(String prefix, String version, String kind) {
        return new VersionedApiResource(prefix, version, ResourceKind.pluralize(kind, true, true));
    }

    private synchronized void init() {
        if (!this.initialized) {
            ArrayList<VersionedApiResource> resourceEndpoints = new ArrayList<VersionedApiResource>();
            Collection<ApiGroup> groups = this.getLegacyGroups();
            groups.addAll(this.getApiGroups());
            groups.forEach(g -> {
                Collection<String> versions = g.getVersions();
                versions.forEach(v -> {
                    Collection<ModelNode> resources = this.getResources((IApiTypeMapper.IApiGroup)g, (String)v);
                    this.addEndpoints(resourceEndpoints, g.getPrefix(), g.getName(), (String)v, resources);
                });
            });
            this.resourceEndpoints = resourceEndpoints;
            this.initialized = true;
        }
    }

    private void addEndpoints(List<VersionedApiResource> endpoints, String prefix, String apiGroupName, String version, Collection<ModelNode> nodes) {
        for (ModelNode node : nodes) {
            String name = node.get("name").asString();
            String capability = null;
            if (name.contains("/")) {
                int first = name.indexOf("/");
                capability = name.substring(first + 1);
                name = name.substring(0, first);
            }
            boolean namespaced = node.get("namespaced").asBoolean();
            VersionedApiResource resource = new VersionedApiResource(prefix, apiGroupName, version, name, node.get("kind").asString(), namespaced);
            if (!endpoints.contains(resource)) {
                endpoints.add(resource);
            }
            if (capability == null) continue;
            int index = endpoints.indexOf(resource);
            endpoints.get(index).addCapability(capability);
        }
    }

    private Collection<ApiGroup> getApiGroups() {
        String json = this.readEndpoint("apis");
        return ModelNode.fromJSONString((String)json).get("groups").asList().stream().map(n -> new ApiGroup("apis", (ModelNode)n)).collect(Collectors.toList());
    }

    private Collection<ModelNode> getResources(IApiTypeMapper.IApiGroup group, String version) {
        String json = this.readEndpoint(group.pathFor(version));
        if (StringUtils.isBlank((String)json)) {
            return new ArrayList<ModelNode>();
        }
        ModelNode node = ModelNode.fromJSONString((String)json);
        return node.get("resources").asList();
    }

    private Collection<ApiGroup> getLegacyGroups() {
        ArrayList<ApiGroup> groups = new ArrayList<ApiGroup>();
        for (String e : Arrays.asList("api", "oapi")) {
            String json = this.readEndpoint(e);
            ModelNode n = ModelNode.fromJSONString((String)json);
            groups.add(new LegacyApiGroup(e, n));
        }
        return groups;
    }

    private String readEndpoint(String endpoint) {
        try {
            URL url = new URL(new URL(this.baseUrl), endpoint);
            LOGGER.debug(url.toString());
            Request request = new Request.Builder().url(url).build();
            Response response = this.client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            throw new OpenShiftException((Throwable)e, "Unable to read endpoint %s/%s", this.baseUrl, endpoint);
        }
    }

    static class VersionedApiResource
    implements IApiTypeMapper.IVersionedApiResource {
        private final String prefix;
        private final String name;
        private final boolean namespaced;
        private final Collection<String> capabilities = new ArrayList<String>();
        private final String version;
        private String apiGroupName;
        private String kind;

        VersionedApiResource(String prefix, String version, String name) {
            if (version == null) {
                throw new IllegalArgumentException("version can not be null when creating a VersionedApiResource ");
            }
            if (version.contains("/")) {
                int last = version.lastIndexOf("/");
                this.apiGroupName = version.substring(0, last);
                version = version.substring(last + 1);
            }
            this.prefix = prefix;
            this.name = name;
            this.version = version;
            this.namespaced = false;
        }

        VersionedApiResource(String prefix, String apiGroupName, String version, String name, String kind, boolean namespaced) {
            this.prefix = prefix;
            this.name = name;
            this.namespaced = namespaced;
            this.version = version;
            this.apiGroupName = apiGroupName;
            this.kind = kind;
        }

        public void addCapability(String capability) {
            this.capabilities.add(capability);
        }

        @Override
        public String getApiGroupName() {
            return this.apiGroupName;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getKind() {
            return this.kind;
        }

        @Override
        public boolean isNamespaced() {
            return this.namespaced;
        }

        @Override
        public boolean isSupported(String capability) {
            return this.capabilities.contains(capability);
        }

        public String toString() {
            if (this.apiGroupName == null) {
                return String.format("%s/%s/%s", this.prefix, this.version, this.name);
            }
            return String.format("%s/%s/%s/%s/%s", this.prefix, this.apiGroupName, this.version, this.name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.apiGroupName == null ? 0 : this.apiGroupName.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VersionedApiResource other = (VersionedApiResource)obj;
            if (this.apiGroupName == null ? other.apiGroupName != null : !this.apiGroupName.equals(other.apiGroupName)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }

    static class LegacyApiGroup
    extends ApiGroup {
        LegacyApiGroup(String prefix, ModelNode node) {
            super(prefix, node);
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Collection<String> getVersions() {
            return JBossDmrExtentions.get(this.getNode(), new HashMap<String, String[]>(), "versions").asList().stream().map(n -> n.asString()).collect(Collectors.toList());
        }

        @Override
        public String getPreferedVersion() {
            return OpenShiftAPIVersion.v1.toString();
        }
    }

    static class ApiGroup
    implements IApiTypeMapper.IApiGroup {
        private final ModelNode node;
        private final String prefix;
        private final String path;

        ApiGroup(String prefix, ModelNode node) {
            this.prefix = prefix;
            this.node = node;
            StringBuilder builder = new StringBuilder(prefix);
            if (this.getName() != null) {
                builder.append("/").append(this.getName());
            }
            this.path = builder.toString();
        }

        protected ModelNode getNode() {
            return this.node;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getName() {
            return JBossDmrExtentions.asString(this.node, new HashMap<String, String[]>(), "name");
        }

        @Override
        public Collection<String> getVersions() {
            return JBossDmrExtentions.get(this.node, new HashMap<String, String[]>(), "versions").asList().stream().map(n -> n.get("version").asString()).collect(Collectors.toList());
        }

        @Override
        public String getPreferedVersion() {
            return JBossDmrExtentions.asString(this.node, new HashMap<String, String[]>(), "preferedVersion.version");
        }

        @Override
        public String pathFor(String version) {
            return String.format("%s/%s", this.path, version);
        }
    }
}

