/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftContext;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.LocationNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenShiftBinaryCapability
implements IBinaryCapability {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOpenShiftBinaryCapability.class);
    private static final boolean IS_MAC = StringUtils.isNotEmpty((String)System.getProperty("os.name")) && System.getProperty("os.name").toLowerCase().contains("mac");
    private Process process;
    private IClient client;

    protected AbstractOpenShiftBinaryCapability(IClient client) {
        this.client = client;
    }

    protected abstract void cleanup();

    protected abstract boolean validate();

    protected abstract String buildArgs(List<IBinaryCapability.OpenShiftBinaryOption> var1);

    protected IClient getClient() {
        return this.client;
    }

    protected AbstractOpenShiftBinaryCapability() {
        this.addShutdownHook();
    }

    protected Process getProcess() {
        return this.process;
    }

    private void addShutdownHook() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractOpenShiftBinaryCapability.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }

    protected String getUserFlag() {
        StringBuilder argBuilder = new StringBuilder();
        argBuilder.append("--user=").append(this.client.getAuthorizationContext().getUserName()).append(" ");
        return argBuilder.toString();
    }

    protected String getServerFlag() {
        StringBuilder argBuilder = new StringBuilder();
        argBuilder.append("--server=").append(this.client.getBaseURL()).append(" ");
        return argBuilder.toString();
    }

    protected String getTokenFlag() {
        return "--token=" + this.client.getAuthorizationContext().getToken() + " ";
    }

    protected String getSkipTlsVerifyFlag() {
        return "--insecure-skip-tls-verify=true ";
    }

    protected String getGitFolderExclusionFlag() {
        return "--exclude='.git' ";
    }

    protected String getNoPermsFlags() {
        return "--no-perms=true ";
    }

    protected String getDeleteFlags() {
        return "--delete ";
    }

    public final void start(IBinaryCapability.OpenShiftBinaryOption ... options) {
        String location = this.getOpenShiftBinaryLocation();
        if (!this.validate()) {
            return;
        }
        ProcessBuilder processBuilder = this.initProcessBuilder(location, options);
        this.startProcess(processBuilder);
    }

    private void startProcess(ProcessBuilder builder) {
        try {
            this.process = builder.start();
            this.checkProcessIsAlive();
        }
        catch (IOException e) {
            LOG.error("Could not start process for {}.", new Object[]{this.getName(), e});
            throw new OpenShiftException((Throwable)e, "Does your OpenShift binary location exist? Error starting process: %s", e.getMessage());
        }
    }

    private ProcessBuilder initProcessBuilder(String location, IBinaryCapability.OpenShiftBinaryOption ... options) {
        ArrayList<String> args = new ArrayList<String>();
        ProcessBuilder builder = null;
        if (IS_MAC) {
            args.add(location);
            Arrays.stream(StringUtils.split((String)this.buildArgs(Arrays.asList(options)))).forEach(s -> args.add((String)s));
            builder = new ProcessBuilder(args);
        } else {
            File oc = new File(location);
            args.add(location);
            Arrays.stream(StringUtils.split((String)this.buildArgs(Arrays.asList(options)))).forEach(s -> args.add((String)s));
            builder = new ProcessBuilder(args);
            builder.directory(oc.getParentFile());
        }
        builder.environment().remove("KUBECONFIG");
        LOG.debug("OpenShift binary args: {}", builder.command());
        return builder;
    }

    private void checkProcessIsAlive() throws IOException {
        block3: {
            try {
                Thread.sleep(1000L);
                if (!this.process.isAlive() && this.process.exitValue() != 0) {
                    throw new OpenShiftException("OpenShiftBinaryCapability process exited: %s", IOUtils.toString((InputStream)this.process.getErrorStream()));
                }
            }
            catch (InterruptedException e) {
                if (this.process.isAlive() || this.process.exitValue() == 0) break block3;
                throw new OpenShiftException("OpenShiftBinaryCapability process exited: %s", IOUtils.toString((InputStream)this.process.getErrorStream()));
            }
        }
    }

    public final synchronized void stop() {
        if (this.process == null) {
            return;
        }
        this.cleanup();
        if (!this.process.isAlive()) {
            int exitValue = this.process.exitValue();
            LOG.debug("OpenShiftBinaryCapability process exit code {}", (Object)exitValue);
            if (exitValue != 0) {
                try {
                    LOG.debug("OpenShiftBinaryCapability process error stream", (Object)IOUtils.toString((InputStream)this.process.getErrorStream()));
                }
                catch (IOException e) {
                    LOG.debug("IOException trying to debug the process error stream", (Throwable)e);
                }
            }
            this.process = null;
            return;
        }
        this.process.destroyForcibly();
    }

    protected String getOpenShiftBinaryLocation() {
        String location = (String)OpenShiftContext.get().get("openshift.restclient.oc.location");
        if (StringUtils.isBlank((String)location)) {
            location = System.getProperty("openshift.restclient.oc.location");
        }
        if (StringUtils.isBlank((String)location)) {
            throw new LocationNotFoundException(String.format("The OpenShift 'oc' binary location was not specified. Set the property %s", "openshift.restclient.oc.location"));
        }
        return location;
    }
}

