/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AbstractOpenShiftBinaryCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.IBinaryCapability;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenShiftBinaryPortForwarding
extends AbstractOpenShiftBinaryCapability
implements IPortForwardable {
    public static final String PORT_FORWARD_COMMAND = "port-forward";
    private final IPod pod;
    private final Collection<IPortForwardable.PortPair> pairs = new ArrayList<IPortForwardable.PortPair>();

    public OpenShiftBinaryPortForwarding(IPod pod, IClient client) {
        super(client);
        this.pod = pod;
    }

    @Override
    protected void cleanup() {
        this.pairs.clear();
    }

    @Override
    protected boolean validate() {
        return !this.pairs.isEmpty();
    }

    @Override
    public boolean isForwarding() {
        return this.getProcess() != null && this.getProcess().isAlive();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return OpenShiftBinaryPortForwarding.class.getSimpleName();
    }

    @Override
    public Collection<IPortForwardable.PortPair> getPortPairs() {
        return this.pairs;
    }

    @Override
    public synchronized void forwardPorts(Collection<IPortForwardable.PortPair> ports, IBinaryCapability.OpenShiftBinaryOption ... options) {
        if (ports == null || ports.isEmpty()) {
            throw new OpenShiftException("Port-forwarding was invoked but no ports were specified.", new Object[0]);
        }
        this.pairs.addAll(ports);
        this.start(options);
    }

    @Override
    protected String buildArgs(List<IBinaryCapability.OpenShiftBinaryOption> options) {
        return new AbstractOpenShiftBinaryCapability.CommandLineBuilder(PORT_FORWARD_COMMAND).append(new AbstractOpenShiftBinaryCapability.Token(this.getClient())).append(new AbstractOpenShiftBinaryCapability.Server(this.getClient())).append(options).append(new AbstractOpenShiftBinaryCapability.Namespace(this.pod)).append(new PodName(this.pod)).append(new PortPairs(this.pairs)).build();
    }

    static class PortPairs
    implements IBinaryCapability.OpenShiftBinaryOption {
        private Collection<IPortForwardable.PortPair> pairs;

        public PortPairs(Collection<IPortForwardable.PortPair> pairs) {
            this.pairs = pairs;
        }

        @Override
        public void append(StringBuilder commandLine) {
            if (this.pairs == null) {
                return;
            }
            for (IPortForwardable.PortPair pair : this.pairs) {
                this.append(pair, commandLine);
            }
        }

        protected void append(IPortForwardable.PortPair pair, StringBuilder commandLine) {
            commandLine.append(" ").append(pair.getLocalPort()).append(":").append(pair.getRemotePort()).append(" ");
        }
    }

    static class PodName
    implements IBinaryCapability.OpenShiftBinaryOption {
        private IPod pod;

        public PodName(IPod pod) {
            this.pod = pod;
        }

        @Override
        public void append(StringBuilder commandLine) {
            commandLine.append(" -p ").append(this.pod.getName());
        }
    }
}

