/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.template;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.template.Parameter;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.ITags;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.IParameter;
import com.openshift.restclient.model.template.ITemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class Template
extends KubernetesResource
implements ITemplate {
    private static final String TEMPLATE_PARAMETERS = "parameters";
    private static final String TEMPLATE_OBJECT_LABELS = "labels";

    public Template(ModelNode node, IClient client, Map<String, String[]> overrideProperties) {
        super(node, client, overrideProperties);
    }

    @Override
    public Map<String, String> getObjectLabels() {
        return Collections.unmodifiableMap(this.asMap(TEMPLATE_OBJECT_LABELS));
    }

    @Override
    public void addObjectLabel(String key, String value) {
        ModelNode labels = this.getNode().get(this.getPath(TEMPLATE_OBJECT_LABELS));
        labels.get(key).set(value);
    }

    @Override
    public Map<String, IParameter> getParameters() {
        HashMap<String, IParameter> params = new HashMap<String, IParameter>();
        ModelNode modelNode = this.get(TEMPLATE_PARAMETERS);
        if (modelNode.isDefined()) {
            List nodes = modelNode.asList();
            for (ModelNode node : nodes) {
                Parameter p = new Parameter(node);
                params.put(p.getName(), p);
            }
        }
        return params;
    }

    @Override
    public Collection<IResource> getObjects() {
        if (!this.getNode().has("objects")) {
            return Collections.emptyList();
        }
        List nodes = this.get("objects").asList();
        ArrayList<IResource> resources = new ArrayList<IResource>(nodes.size());
        IResourceFactory factory = this.getClient().getResourceFactory();
        if (factory != null) {
            for (ModelNode node : nodes) {
                resources.add((IResource)factory.create(node.toJSONString(true)));
            }
        }
        return resources;
    }

    @Override
    public void updateParameterValues(Collection<IParameter> parameters) {
        Map<String, IParameter> actuals = this.getParameters();
        for (IParameter param : parameters) {
            if (!actuals.containsKey(param.getName())) continue;
            actuals.get(param.getName()).setValue(param.getValue());
        }
    }

    @Override
    public void updateParameter(String key, String value) {
        Map<String, IParameter> params = this.getParameters();
        if (params.containsKey(key)) {
            params.get(key).setValue(value);
        }
    }

    @Override
    public boolean isMatching(final String text) {
        if (StringUtils.isBlank((String)text)) {
            return true;
        }
        if (this.getName().contains(text)) {
            return true;
        }
        return this.accept(new CapabilityVisitor<ITags, Boolean>(){

            @Override
            public Boolean visit(ITags capability) {
                for (String tag : capability.getTags()) {
                    if (!tag.contains(text)) continue;
                    return true;
                }
                return false;
            }
        }, false);
    }
}

