/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.DockerRegistryImageStreamImportCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.UnsupportedEndpointException;
import com.openshift.restclient.authorization.ResourceForbiddenException;
import com.openshift.restclient.capability.resources.IImageStreamImportCapability;
import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IStatus;
import com.openshift.restclient.model.image.IImageStreamImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamImportCapability
implements IImageStreamImportCapability {
    private static final Logger LOG = LoggerFactory.getLogger(IImageStreamImportCapability.class);
    private IClient client;
    private IProject project;

    public ImageStreamImportCapability(IProject project, IClient client) {
        this.project = project;
        this.client = client;
    }

    @Override
    public IImageStreamImport importImageMetadata(DockerImageURI uri) {
        LOG.debug("first trying imagestreamimport against OpenShift server...");
        IImageStreamImport streamImport = (IImageStreamImport)this.client.getResourceFactory().stub("ImageStreamImport", "jbosstools-openshift-deployimage", this.project.getName());
        streamImport.setImport(false);
        streamImport.addImage("DockerImage", uri);
        try {
            IImageStreamImport result = this.client.create(streamImport);
            for (IStatus status : result.getImageStatus()) {
                if (!"Success".equalsIgnoreCase(status.getStatus())) continue;
                return result;
            }
        }
        catch (UnsupportedEndpointException | ResourceForbiddenException e) {
            LOG.info("Unsuccessful in trying OpenShift server. ImageStreamImport is not supported.");
        }
        LOG.debug("Unsuccessful in trying OpenShift server.  Trying dockerhub v2 registry...");
        DockerRegistryImageStreamImportCapability reg = new DockerRegistryImageStreamImportCapability(this.project, this.client.getResourceFactory(), this.client);
        return reg.importImageMetadata(uri);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return ImageStreamImportCapability.class.getSimpleName();
    }
}

