/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.api.capabilities;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.URLBuilder;
import com.openshift.internal.restclient.capability.AbstractCapability;
import com.openshift.internal.restclient.okhttp.OpenShiftRequestBuilder;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.api.capabilities.IPodExec;
import com.openshift.restclient.capability.IStoppable;
import com.openshift.restclient.model.IPod;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodExec
extends AbstractCapability
implements IPodExec {
    private static final Logger LOG = LoggerFactory.getLogger(IPodExec.class);
    private static final String CAPABILITY = "exec";
    private static final String COMMAND = "command";
    private static final String K8S_PROTOCOL_HEADER = "X-Stream-Protocol-Version";
    private static final String K8S_PROTOCOL = "channel.k8s.io";
    public static final int CHANNEL_STDOUT = 1;
    public static final int CHANNEL_STDERR = 2;
    public static final int CHANNEL_EXECERR = 3;
    private final IPod pod;
    private final DefaultClient client;
    private final IApiTypeMapper mapper;

    public PodExec(IPod pod, IClient client) {
        super(pod, client, CAPABILITY);
        this.pod = pod;
        this.client = client.adapt(DefaultClient.class);
        this.mapper = client.adapt(IApiTypeMapper.class);
    }

    @Override
    public String getName() {
        return PodExec.class.getSimpleName();
    }

    @Override
    public IStoppable start(IPodExec.IPodExecOutputListener listener, IPodExec.Options options, String ... commands) {
        if (options == null) {
            options = new IPodExec.Options();
        }
        options.stdErr(true);
        options.stdOut(true);
        Map<String, String> parameters = options.getMap();
        OkHttpClient okClient = this.client.adapt(OkHttpClient.class);
        URLBuilder urlBuilder = new URLBuilder(this.client.getBaseURL(), this.mapper).resource(this.pod).subresource(CAPABILITY).addParameters(parameters);
        for (String command : commands) {
            urlBuilder.addParmeter(COMMAND, command);
        }
        String endpoint = urlBuilder.websocket();
        Request request = new OpenShiftRequestBuilder().url(endpoint).method("GET", null).accept("*/*").authorization(this.client.getAuthorizationContext()).addHeader(K8S_PROTOCOL_HEADER, K8S_PROTOCOL).tag(new ResponseCodeInterceptor.Ignore(){}).build();
        ExecOutputListenerAdapter adapter = new ExecOutputListenerAdapter(listener);
        okClient.newWebSocket(request, (WebSocketListener)adapter);
        return adapter;
    }

    static class ExecOutputListenerAdapter
    extends WebSocketListener
    implements IStoppable {
        private final IPodExec.IPodExecOutputListener listener;
        private WebSocket call;
        private AtomicBoolean open = new AtomicBoolean(false);
        private boolean shouldStop = false;

        public ExecOutputListenerAdapter(IPodExec.IPodExecOutputListener listener) {
            this.listener = listener;
        }

        @Override
        public void stop() {
            if (this.call != null) {
                this.call.cancel();
            } else {
                this.shouldStop = true;
            }
        }

        public void onOpen(WebSocket webSocket, Response response) {
            if (this.open.compareAndSet(false, true)) {
                this.call = webSocket;
                this.listener.onOpen();
                if (this.shouldStop) {
                    webSocket.cancel();
                }
            }
        }

        public void onClosing(WebSocket socket, int code, String reason) {
            if (this.open.compareAndSet(true, false)) {
                this.listener.onClose(code, reason);
            }
        }

        public void onFailure(WebSocket socket, Throwable e, Response response) {
            this.listener.onFailure(e);
        }

        public void deliver(int channel, String msg) {
            switch (channel) {
                case 1: {
                    this.listener.onStdOut(msg);
                    break;
                }
                case 2: {
                    this.listener.onStdErr(msg);
                    break;
                }
                case 3: {
                    this.listener.onExecErr(msg);
                    break;
                }
                default: {
                    LOG.warn("Unable to deliver exec message of type [%d]: %s", (Object)channel, (Object)msg);
                }
            }
        }

        public void onMessage(WebSocket webSocket, String text) {
            throw new IllegalStateException("Should not receive text message on pod exec sockets");
        }

        public void onMessage(WebSocket socket, ByteString message) {
            byte channel = message.getByte(0);
            String msg = message.substring(1).utf8();
            this.deliver(channel, msg);
        }
    }
}

