/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.okhttp.IChallengeHandler;
import com.openshift.restclient.authorization.IAuthorizationContext;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Request;
import org.apache.commons.lang.StringUtils;

public class BasicChallengeHandler
implements IChallengeHandler {
    private IAuthorizationContext context;

    public BasicChallengeHandler(IAuthorizationContext context) {
        this.context = context;
    }

    @Override
    public boolean canHandle(Headers headers) {
        return "Basic".equalsIgnoreCase(headers.get("Www-Authenticate"));
    }

    @Override
    public Request.Builder handleChallenge(Request.Builder builder) {
        return builder.header("Authorization", Credentials.basic((String)StringUtils.defaultIfBlank((String)this.context.getUserName(), (String)""), (String)StringUtils.defaultIfBlank((String)this.context.getPassword(), (String)"")));
    }
}

