/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.internal.restclient.authorization.AuthorizationDetails;
import com.openshift.internal.restclient.okhttp.BasicChallengeHandler;
import com.openshift.internal.restclient.okhttp.IChallengeHandler;
import com.openshift.internal.restclient.okhttp.OpenShiftRequestBuilder;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.internal.util.URIUtils;
import com.openshift.restclient.IClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.authorization.UnauthorizedException;
import com.openshift.restclient.http.IHttpConstants;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthenticatorInterceptor
implements Interceptor,
IHttpConstants {
    private static final Logger LOGGER = Logger.getLogger(AuthenticatorInterceptor.class);
    public static final String ACCESS_TOKEN = "access_token";
    private static final String AUTH_ATTEMPTS = "X-OPENSHIFT-AUTH-ATTEMPTS";
    private static final String CSRF_TOKEN = "X-CSRF-Token";
    private static final String ERROR = "error";
    private static final String ERROR_DETAILS = "error_details";
    private IClient client;
    private Collection<IChallengeHandler> challangeHandlers = new ArrayList<IChallengeHandler>();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String url;
        Request request = chain.request();
        if (this.isUrlWithoutAuthorization(request, url = request.url().toString())) {
            return chain.proceed(request);
        }
        IAuthorizationContext authorizationContext = this.client.getAuthorizationContext();
        if (StringUtils.isBlank((String)authorizationContext.getToken())) {
            try (Response authResponse = this.authenticate();){
                if (authResponse == null || !authResponse.isSuccessful()) {
                    throw new UnauthorizedException(this.getAuthorizationDetails(url), authResponse == null ? null : ResponseCodeInterceptor.getStatus(authResponse.body().string()));
                }
                String token = this.getToken(authResponse);
                this.setToken(token, this.client.getAuthorizationContext());
                request = new OpenShiftRequestBuilder(request.newBuilder()).acceptJson().authorization(authorizationContext).build();
            }
        }
        return chain.proceed(request);
    }

    private boolean isUrlWithoutAuthorization(Request request, String url) {
        return url.endsWith("version/openshift") || url.endsWith("version") || url.endsWith(".well-known/oauth-authorization-server") || request.url().toString().startsWith(this.client.getAuthorizationEndpoint().toString());
    }

    private Response authenticate() throws IOException {
        OkHttpClient okClient = this.client.adapt(OkHttpClient.class);
        if (okClient == null) {
            return null;
        }
        Request authRequest = new Request.Builder().addHeader(CSRF_TOKEN, "1").url(new URL(this.client.getAuthorizationEndpoint().toExternalForm() + "?response_type=token&client_id=openshift-challenging-client").toString()).build();
        return okClient.newBuilder().authenticator((Authenticator)new OpenShiftAuthenticator()).followRedirects(false).build().newCall(authRequest).execute();
    }

    private IAuthorizationDetails getAuthorizationDetails(String url) {
        AuthorizationDetails details = null;
        Map<String, String> pairs = URIUtils.splitFragment(url);
        if (pairs.containsKey(ERROR)) {
            details = new AuthorizationDetails(pairs.get(ERROR), pairs.get(ERROR_DETAILS));
        }
        return details;
    }

    private String getToken(Response response) {
        String token = null;
        Map<String, String> pairs = URIUtils.splitFragment(response.header("Location"));
        if (pairs.containsKey(ACCESS_TOKEN)) {
            token = pairs.get(ACCESS_TOKEN);
        }
        return token;
    }

    private void setToken(String token, IAuthorizationContext authorizationContext) {
        if (authorizationContext != null) {
            authorizationContext.setToken(token);
        }
    }

    public void setClient(IClient client) {
        this.client = client;
        this.initChallengeHandlers(client.getAuthorizationContext());
    }

    private void initChallengeHandlers(IAuthorizationContext context) {
        this.challangeHandlers.clear();
        this.challangeHandlers.add(new BasicChallengeHandler(context));
    }

    private final class OpenShiftAuthenticator
    implements Authenticator {
        private OpenShiftAuthenticator() {
        }

        public Request authenticate(Route route, Response response) throws IOException {
            if (StringUtils.isNotBlank((String)response.request().header(AuthenticatorInterceptor.AUTH_ATTEMPTS))) {
                return null;
            }
            if (StringUtils.isNotBlank((String)response.header("Www-Authenticate"))) {
                Request authenticationRequest = this.createAuthenticationRequest(response);
                response.close();
                return authenticationRequest;
            }
            return null;
        }

        private Request createAuthenticationRequest(Response response) {
            for (IChallengeHandler challangeHandler : AuthenticatorInterceptor.this.challangeHandlers) {
                if (challangeHandler.canHandle(response.headers())) continue;
                Request.Builder requestBuilder = response.request().newBuilder().header(AuthenticatorInterceptor.AUTH_ATTEMPTS, "1");
                return challangeHandler.handleChallenge(requestBuilder).build();
            }
            return null;
        }
    }
}

