/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.authorization;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.model.IStatus;
import org.apache.commons.lang.StringUtils;

public class UnauthorizedException
extends OpenShiftException {
    private static final long serialVersionUID = -3999801367045252906L;
    private static final String MSG_BASE = "Unauthorized to access resource.";
    private final String message;
    private final IStatus status;
    private final IAuthorizationDetails details;

    public UnauthorizedException(IAuthorizationDetails details) {
        this(details, null);
    }

    public UnauthorizedException(IAuthorizationDetails details, IStatus status) {
        super("Unauthorized to access resource. See the authorization details for additional information or contact your system administrator.", new Object[0]);
        this.status = status;
        this.details = details;
        this.message = details != null ? (StringUtils.isNotBlank((String)details.getScheme()) ? String.format("%s You can access the server using %s authentication.", MSG_BASE, details.getScheme()) : details.getMessage()) : super.getMessage();
    }

    public IAuthorizationDetails getAuthorizationDetails() {
        return this.details;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }
}

