/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.okhttp;

import com.openshift.restclient.authorization.IAuthorizationContext;
import java.net.URL;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.lang.StringUtils;

public class OpenShiftRequestBuilder {
    private Request.Builder builder;

    public OpenShiftRequestBuilder() {
        this(new Request.Builder());
    }

    public OpenShiftRequestBuilder(Request.Builder builder) {
        this.builder = builder;
    }

    public OpenShiftRequestBuilder accept(String mediaType) {
        this.builder.header("Accept", mediaType);
        return this;
    }

    public OpenShiftRequestBuilder acceptJson() {
        this.builder.header("Accept", "application/json;charset=utf-8");
        return this;
    }

    public OpenShiftRequestBuilder authorization(IAuthorizationContext authorizationContext) {
        String token = null;
        if (authorizationContext != null && StringUtils.isNotBlank((String)authorizationContext.getToken())) {
            token = authorizationContext.getToken();
        }
        return this.authorization(token);
    }

    public OpenShiftRequestBuilder authorization(String token) {
        if (!StringUtils.isBlank((String)token)) {
            this.builder.header("Authorization", "Bearer " + token);
        }
        return this;
    }

    public OpenShiftRequestBuilder url(URL url) {
        this.builder.url(url);
        return this;
    }

    public OpenShiftRequestBuilder url(String url) {
        this.builder.url(url);
        return this;
    }

    public OpenShiftRequestBuilder method(String method, RequestBody body) {
        this.builder.method(method, body);
        return this;
    }

    public OpenShiftRequestBuilder addHeader(String key, String value) {
        this.builder.addHeader(key, value);
        return this;
    }

    public OpenShiftRequestBuilder header(String key, String value) {
        this.builder.header(key, value);
        return this;
    }

    public OpenShiftRequestBuilder tag(Object tag) {
        this.builder.tag(tag);
        return this;
    }

    public Request.Builder builder() {
        return this.builder;
    }

    public Request build() {
        return this.builder.build();
    }
}

