/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteChannelListener;
import com.oracle.bedrock.runtime.concurrent.socket.SocketBasedRemoteChannelClient;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

@Internal
public class JavaApplicationRunner {
    public static SocketBasedRemoteChannelClient channel = null;

    public static void main(String[] arguments) {
        if (arguments.length == 0) {
            System.out.println("JavaApplicationRunner: No application (fqcn) was specified to start. An application must be specified as an argument.");
            Runtime.getRuntime().halt(1);
        } else {
            String[] applicationArguments;
            String applicationClassName;
            block13: {
                String parent = System.getProperty("bedrock.runtime.parent", null);
                final boolean isOrphanable = Boolean.getBoolean("bedrock.runtime.orphanable");
                if (parent == null) {
                    System.out.println("JavaApplicationRunner: No parent URI was specified.  The parent URI must be specified to start the application.");
                    Runtime.getRuntime().halt(1);
                }
                applicationClassName = arguments[0];
                applicationArguments = new String[arguments.length - 1];
                System.arraycopy(arguments, 1, applicationArguments, 0, arguments.length - 1);
                try {
                    URI parentURI = new URI(parent);
                    InetAddress inetAddress = InetAddress.getByName(parentURI.getHost());
                    channel = new SocketBasedRemoteChannelClient(inetAddress, parentURI.getPort());
                    channel.addListener(new RemoteChannelListener(){

                        @Override
                        public void onOpened(RemoteChannel channel) {
                        }

                        @Override
                        public void onClosed(RemoteChannel channel) {
                            if (!isOrphanable) {
                                Runtime.getRuntime().halt(2);
                            }
                        }
                    });
                    channel.open();
                }
                catch (URISyntaxException e) {
                    System.out.println("JavaApplicationRunner: The specified parent URI [" + parent + "] is invalid");
                    e.printStackTrace(System.out);
                }
                catch (UnknownHostException e) {
                    System.out.println("JavaApplicationRunner: The specified parent address is unknown");
                    e.printStackTrace(System.out);
                }
                catch (IOException e) {
                    System.out.println("JavaApplicationRunner: Failed to open a connection to parent");
                    e.printStackTrace(System.out);
                    if (channel == null) break block13;
                    channel.close();
                    channel = null;
                }
            }
            if (channel != null) {
                try {
                    Class<?> applicationClass = Class.forName(applicationClassName);
                    Method mainMethod = applicationClass.getMethod("main", String[].class);
                    mainMethod.invoke(null, new Object[]{applicationArguments});
                }
                catch (ClassNotFoundException e) {
                    System.out.println("JavaApplicationRunner: Could not load the class " + applicationClassName);
                    e.printStackTrace(System.out);
                }
                catch (NoSuchMethodException e) {
                    System.out.println("JavaApplicationRunner: Could not locate a main method for " + applicationClassName);
                    e.printStackTrace(System.out);
                }
                catch (IllegalAccessException e) {
                    System.out.println("JavaApplicationRunner: Could not access the main method for " + applicationClassName);
                    e.printStackTrace(System.out);
                }
                catch (InvocationTargetException e) {
                    System.out.println("JavaApplicationRunner: Failed to invoke the main method for " + applicationClassName);
                    e.printStackTrace(System.out);
                }
            }
        }
    }
}

