/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.accessgovernancecp.model;

/**
 * The details of a tenancy-wide configuration for GovernanceInstances to be updated. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220518")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = UpdateGovernanceInstanceConfigurationDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class UpdateGovernanceInstanceConfigurationDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"senderInfo"})
    public UpdateGovernanceInstanceConfigurationDetails(UpdateSenderConfig senderInfo) {
        super();
        this.senderInfo = senderInfo;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {

        @com.fasterxml.jackson.annotation.JsonProperty("senderInfo")
        private UpdateSenderConfig senderInfo;

        public Builder senderInfo(UpdateSenderConfig senderInfo) {
            this.senderInfo = senderInfo;
            this.__explicitlySet__.add("senderInfo");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public UpdateGovernanceInstanceConfigurationDetails build() {
            UpdateGovernanceInstanceConfigurationDetails model =
                    new UpdateGovernanceInstanceConfigurationDetails(this.senderInfo);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(UpdateGovernanceInstanceConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("senderInfo")) {
                this.senderInfo(model.getSenderInfo());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @com.fasterxml.jackson.annotation.JsonProperty("senderInfo")
    private final UpdateSenderConfig senderInfo;

    public UpdateSenderConfig getSenderInfo() {
        return senderInfo;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("UpdateGovernanceInstanceConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("senderInfo=").append(String.valueOf(this.senderInfo));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateGovernanceInstanceConfigurationDetails)) {
            return false;
        }

        UpdateGovernanceInstanceConfigurationDetails other =
                (UpdateGovernanceInstanceConfigurationDetails) o;
        return java.util.Objects.equals(this.senderInfo, other.senderInfo) && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.senderInfo == null ? 43 : this.senderInfo.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
