/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.adm.model;

/**
 * An application dependency resource creates a vulnerability audit. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220421")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ApplicationDependency.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ApplicationDependency
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"gav", "purl", "nodeId", "applicationDependencyNodeIds"})
    public ApplicationDependency(
            String gav,
            String purl,
            String nodeId,
            java.util.List<String> applicationDependencyNodeIds) {
        super();
        this.gav = gav;
        this.purl = purl;
        this.nodeId = nodeId;
        this.applicationDependencyNodeIds = applicationDependencyNodeIds;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example:
         * org.graalvm.nativeimage:svm:21.1.0. "N/A" for non-maven artifacts.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("gav")
        private String gav;

        /**
         * Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example:
         * org.graalvm.nativeimage:svm:21.1.0. "N/A" for non-maven artifacts.
         *
         * @param gav the value to set
         * @return this builder
         */
        public Builder gav(String gav) {
            this.gav = gav;
            this.__explicitlySet__.add("gav");
            return this;
        }
        /**
         * Package URL defined in https://github.com/package-url/purl-spec, e.g.
         * pkg:maven/org.graalvm.nativeimage/svm@21.1.0
         */
        @com.fasterxml.jackson.annotation.JsonProperty("purl")
        private String purl;

        /**
         * Package URL defined in https://github.com/package-url/purl-spec, e.g.
         * pkg:maven/org.graalvm.nativeimage/svm@21.1.0
         *
         * @param purl the value to set
         * @return this builder
         */
        public Builder purl(String purl) {
            this.purl = purl;
            this.__explicitlySet__.add("purl");
            return this;
        }
        /**
         * Unique identifier of an application dependency, for example nodeId1. The nodeId can be
         * generated by assigning a unique id to each application dependency in the tree of
         * application dependencies. Every node, even those who share the same GAV, should have a
         * different nodeId. The preferred way of constructing a nodeId is to assign incremental
         * integers during a breadth first or depth first search. A nodeId can be reused only it
         * refers to the same subtree of application dependencies. (This is not equivalent to
         * referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("nodeId")
        private String nodeId;

        /**
         * Unique identifier of an application dependency, for example nodeId1. The nodeId can be
         * generated by assigning a unique id to each application dependency in the tree of
         * application dependencies. Every node, even those who share the same GAV, should have a
         * different nodeId. The preferred way of constructing a nodeId is to assign incremental
         * integers during a breadth first or depth first search. A nodeId can be reused only it
         * refers to the same subtree of application dependencies. (This is not equivalent to
         * referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
         *
         * @param nodeId the value to set
         * @return this builder
         */
        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            this.__explicitlySet__.add("nodeId");
            return this;
        }
        /**
         * List of application dependencies on which this application dependency depends, each
         * identified by its nodeId.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("applicationDependencyNodeIds")
        private java.util.List<String> applicationDependencyNodeIds;

        /**
         * List of application dependencies on which this application dependency depends, each
         * identified by its nodeId.
         *
         * @param applicationDependencyNodeIds the value to set
         * @return this builder
         */
        public Builder applicationDependencyNodeIds(
                java.util.List<String> applicationDependencyNodeIds) {
            this.applicationDependencyNodeIds = applicationDependencyNodeIds;
            this.__explicitlySet__.add("applicationDependencyNodeIds");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ApplicationDependency build() {
            ApplicationDependency model =
                    new ApplicationDependency(
                            this.gav, this.purl, this.nodeId, this.applicationDependencyNodeIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ApplicationDependency model) {
            if (model.wasPropertyExplicitlySet("gav")) {
                this.gav(model.getGav());
            }
            if (model.wasPropertyExplicitlySet("purl")) {
                this.purl(model.getPurl());
            }
            if (model.wasPropertyExplicitlySet("nodeId")) {
                this.nodeId(model.getNodeId());
            }
            if (model.wasPropertyExplicitlySet("applicationDependencyNodeIds")) {
                this.applicationDependencyNodeIds(model.getApplicationDependencyNodeIds());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example:
     * org.graalvm.nativeimage:svm:21.1.0. "N/A" for non-maven artifacts.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("gav")
    private final String gav;

    /**
     * Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example:
     * org.graalvm.nativeimage:svm:21.1.0. "N/A" for non-maven artifacts.
     *
     * @return the value
     */
    public String getGav() {
        return gav;
    }

    /**
     * Package URL defined in https://github.com/package-url/purl-spec, e.g.
     * pkg:maven/org.graalvm.nativeimage/svm@21.1.0
     */
    @com.fasterxml.jackson.annotation.JsonProperty("purl")
    private final String purl;

    /**
     * Package URL defined in https://github.com/package-url/purl-spec, e.g.
     * pkg:maven/org.graalvm.nativeimage/svm@21.1.0
     *
     * @return the value
     */
    public String getPurl() {
        return purl;
    }

    /**
     * Unique identifier of an application dependency, for example nodeId1. The nodeId can be
     * generated by assigning a unique id to each application dependency in the tree of application
     * dependencies. Every node, even those who share the same GAV, should have a different nodeId.
     * The preferred way of constructing a nodeId is to assign incremental integers during a breadth
     * first or depth first search. A nodeId can be reused only it refers to the same subtree of
     * application dependencies. (This is not equivalent to referring to the same GAV, that is, a
     * GAV can have multiple transitive dependencies.)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("nodeId")
    private final String nodeId;

    /**
     * Unique identifier of an application dependency, for example nodeId1. The nodeId can be
     * generated by assigning a unique id to each application dependency in the tree of application
     * dependencies. Every node, even those who share the same GAV, should have a different nodeId.
     * The preferred way of constructing a nodeId is to assign incremental integers during a breadth
     * first or depth first search. A nodeId can be reused only it refers to the same subtree of
     * application dependencies. (This is not equivalent to referring to the same GAV, that is, a
     * GAV can have multiple transitive dependencies.)
     *
     * @return the value
     */
    public String getNodeId() {
        return nodeId;
    }

    /**
     * List of application dependencies on which this application dependency depends, each
     * identified by its nodeId.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("applicationDependencyNodeIds")
    private final java.util.List<String> applicationDependencyNodeIds;

    /**
     * List of application dependencies on which this application dependency depends, each
     * identified by its nodeId.
     *
     * @return the value
     */
    public java.util.List<String> getApplicationDependencyNodeIds() {
        return applicationDependencyNodeIds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ApplicationDependency(");
        sb.append("super=").append(super.toString());
        sb.append("gav=").append(String.valueOf(this.gav));
        sb.append(", purl=").append(String.valueOf(this.purl));
        sb.append(", nodeId=").append(String.valueOf(this.nodeId));
        sb.append(", applicationDependencyNodeIds=")
                .append(String.valueOf(this.applicationDependencyNodeIds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationDependency)) {
            return false;
        }

        ApplicationDependency other = (ApplicationDependency) o;
        return java.util.Objects.equals(this.gav, other.gav)
                && java.util.Objects.equals(this.purl, other.purl)
                && java.util.Objects.equals(this.nodeId, other.nodeId)
                && java.util.Objects.equals(
                        this.applicationDependencyNodeIds, other.applicationDependencyNodeIds)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.gav == null ? 43 : this.gav.hashCode());
        result = (result * PRIME) + (this.purl == null ? 43 : this.purl.hashCode());
        result = (result * PRIME) + (this.nodeId == null ? 43 : this.nodeId.hashCode());
        result =
                (result * PRIME)
                        + (this.applicationDependencyNodeIds == null
                                ? 43
                                : this.applicationDependencyNodeIds.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
