/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.computecloudatcustomer.responses;

import com.oracle.bmc.computecloudatcustomer.model.*;

@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20221208")
public class GetCccUpgradeScheduleResponse extends com.oracle.bmc.responses.BmcResponse {
    /** For optimistic concurrency control. See {@code if-match}. */
    private String etag;

    /**
     * For optimistic concurrency control. See {@code if-match}.
     *
     * @return the value
     */
    public String getEtag() {
        return etag;
    }

    /**
     * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
     * particular request, please provide the request ID.
     */
    private String opcRequestId;

    /**
     * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
     * particular request, please provide the request ID.
     *
     * @return the value
     */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    /** The returned {@code CccUpgradeSchedule} instance. */
    private com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule cccUpgradeSchedule;

    /**
     * The returned {@code CccUpgradeSchedule} instance.
     *
     * @return the value
     */
    public com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule getCccUpgradeSchedule() {
        return cccUpgradeSchedule;
    }

    @java.beans.ConstructorProperties({
        "__httpStatusCode__",
        "headers",
        "etag",
        "opcRequestId",
        "cccUpgradeSchedule"
    })
    private GetCccUpgradeScheduleResponse(
            int __httpStatusCode__,
            java.util.Map<String, java.util.List<String>> headers,
            String etag,
            String opcRequestId,
            com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule cccUpgradeSchedule) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.cccUpgradeSchedule = cccUpgradeSchedule;
    }

    public static class Builder
            implements com.oracle.bmc.responses.BmcResponse.Builder<GetCccUpgradeScheduleResponse> {
        private int __httpStatusCode__;

        @Override
        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        private java.util.Map<String, java.util.List<String>> headers;

        @Override
        public Builder headers(java.util.Map<String, java.util.List<String>> headers) {
            this.headers = headers;
            return this;
        }

        /** For optimistic concurrency control. See {@code if-match}. */
        private String etag;

        /**
         * For optimistic concurrency control. See {@code if-match}.
         *
         * @param etag the value to set
         * @return this builder
         */
        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        /**
         * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
         * particular request, please provide the request ID.
         */
        private String opcRequestId;

        /**
         * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
         * particular request, please provide the request ID.
         *
         * @param opcRequestId the value to set
         * @return this builder
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /** The returned {@code CccUpgradeSchedule} instance. */
        private com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule cccUpgradeSchedule;

        /**
         * The returned {@code CccUpgradeSchedule} instance.
         *
         * @param cccUpgradeSchedule the value to set
         * @return this builder
         */
        public Builder cccUpgradeSchedule(
                com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule cccUpgradeSchedule) {
            this.cccUpgradeSchedule = cccUpgradeSchedule;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        @Override
        public Builder copy(GetCccUpgradeScheduleResponse o) {
            __httpStatusCode__(o.get__httpStatusCode__());
            headers(o.getHeaders());
            etag(o.getEtag());
            opcRequestId(o.getOpcRequestId());
            cccUpgradeSchedule(o.getCccUpgradeSchedule());

            return this;
        }

        /**
         * Build the response object.
         *
         * @return the response object
         */
        @Override
        public GetCccUpgradeScheduleResponse build() {
            return new GetCccUpgradeScheduleResponse(
                    __httpStatusCode__, headers, etag, opcRequestId, cccUpgradeSchedule);
        }
    }

    /**
     * Return a new builder for this response object.
     *
     * @return builder for the response object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(etag));
        sb.append(",opcRequestId=").append(String.valueOf(opcRequestId));
        sb.append(",cccUpgradeSchedule=").append(String.valueOf(cccUpgradeSchedule));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCccUpgradeScheduleResponse)) {
            return false;
        }

        GetCccUpgradeScheduleResponse other = (GetCccUpgradeScheduleResponse) o;
        return super.equals(o)
                && java.util.Objects.equals(this.etag, other.etag)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(this.cccUpgradeSchedule, other.cccUpgradeSchedule);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.etag == null ? 43 : this.etag.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result =
                (result * PRIME)
                        + (this.cccUpgradeSchedule == null
                                ? 43
                                : this.cccUpgradeSchedule.hashCode());
        return result;
    }
}
