/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.core.model;

/**
 * The platform configuration used when launching a bare metal GPU instance with the following
 * shape: BM.GPU.GM4.8 (also named BM.GPU.A100-v2.8) (the AMD Milan platform). <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = AmdMilanBmGpuPlatformConfig.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "type")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class AmdMilanBmGpuPlatformConfig extends PlatformConfig {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        @com.fasterxml.jackson.annotation.JsonProperty("isSecureBootEnabled")
        private Boolean isSecureBootEnabled;

        public Builder isSecureBootEnabled(Boolean isSecureBootEnabled) {
            this.isSecureBootEnabled = isSecureBootEnabled;
            this.__explicitlySet__.add("isSecureBootEnabled");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("isTrustedPlatformModuleEnabled")
        private Boolean isTrustedPlatformModuleEnabled;

        public Builder isTrustedPlatformModuleEnabled(Boolean isTrustedPlatformModuleEnabled) {
            this.isTrustedPlatformModuleEnabled = isTrustedPlatformModuleEnabled;
            this.__explicitlySet__.add("isTrustedPlatformModuleEnabled");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("isMeasuredBootEnabled")
        private Boolean isMeasuredBootEnabled;

        public Builder isMeasuredBootEnabled(Boolean isMeasuredBootEnabled) {
            this.isMeasuredBootEnabled = isMeasuredBootEnabled;
            this.__explicitlySet__.add("isMeasuredBootEnabled");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("isMemoryEncryptionEnabled")
        private Boolean isMemoryEncryptionEnabled;

        public Builder isMemoryEncryptionEnabled(Boolean isMemoryEncryptionEnabled) {
            this.isMemoryEncryptionEnabled = isMemoryEncryptionEnabled;
            this.__explicitlySet__.add("isMemoryEncryptionEnabled");
            return this;
        }
        /** The number of NUMA nodes per socket (NPS). */
        @com.fasterxml.jackson.annotation.JsonProperty("numaNodesPerSocket")
        private NumaNodesPerSocket numaNodesPerSocket;

        /**
         * The number of NUMA nodes per socket (NPS).
         *
         * @param numaNodesPerSocket the value to set
         * @return this builder
         */
        public Builder numaNodesPerSocket(NumaNodesPerSocket numaNodesPerSocket) {
            this.numaNodesPerSocket = numaNodesPerSocket;
            this.__explicitlySet__.add("numaNodesPerSocket");
            return this;
        }
        /**
         * Whether symmetric multithreading is enabled on the instance. Symmetric multithreading is
         * also called simultaneous multithreading (SMT) or Intel Hyper-Threading.
         *
         * <p>Intel and AMD processors have two hardware execution threads per core (OCPU). SMT
         * permits multiple independent threads of execution, to better use the resources and
         * increase the efficiency of the CPU. When multithreading is disabled, only one thread is
         * permitted to run on each core, which can provide higher or more predictable performance
         * for some workloads.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isSymmetricMultiThreadingEnabled")
        private Boolean isSymmetricMultiThreadingEnabled;

        /**
         * Whether symmetric multithreading is enabled on the instance. Symmetric multithreading is
         * also called simultaneous multithreading (SMT) or Intel Hyper-Threading.
         *
         * <p>Intel and AMD processors have two hardware execution threads per core (OCPU). SMT
         * permits multiple independent threads of execution, to better use the resources and
         * increase the efficiency of the CPU. When multithreading is disabled, only one thread is
         * permitted to run on each core, which can provide higher or more predictable performance
         * for some workloads.
         *
         * @param isSymmetricMultiThreadingEnabled the value to set
         * @return this builder
         */
        public Builder isSymmetricMultiThreadingEnabled(Boolean isSymmetricMultiThreadingEnabled) {
            this.isSymmetricMultiThreadingEnabled = isSymmetricMultiThreadingEnabled;
            this.__explicitlySet__.add("isSymmetricMultiThreadingEnabled");
            return this;
        }
        /**
         * Whether the Access Control Service is enabled on the instance. When enabled, the platform
         * can enforce PCIe device isolation, required for VFIO device pass-through.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isAccessControlServiceEnabled")
        private Boolean isAccessControlServiceEnabled;

        /**
         * Whether the Access Control Service is enabled on the instance. When enabled, the platform
         * can enforce PCIe device isolation, required for VFIO device pass-through.
         *
         * @param isAccessControlServiceEnabled the value to set
         * @return this builder
         */
        public Builder isAccessControlServiceEnabled(Boolean isAccessControlServiceEnabled) {
            this.isAccessControlServiceEnabled = isAccessControlServiceEnabled;
            this.__explicitlySet__.add("isAccessControlServiceEnabled");
            return this;
        }
        /**
         * Whether virtualization instructions are available. For example, Secure Virtual Machine
         * for AMD shapes or VT-x for Intel shapes.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("areVirtualInstructionsEnabled")
        private Boolean areVirtualInstructionsEnabled;

        /**
         * Whether virtualization instructions are available. For example, Secure Virtual Machine
         * for AMD shapes or VT-x for Intel shapes.
         *
         * @param areVirtualInstructionsEnabled the value to set
         * @return this builder
         */
        public Builder areVirtualInstructionsEnabled(Boolean areVirtualInstructionsEnabled) {
            this.areVirtualInstructionsEnabled = areVirtualInstructionsEnabled;
            this.__explicitlySet__.add("areVirtualInstructionsEnabled");
            return this;
        }
        /** Whether the input-output memory management unit is enabled. */
        @com.fasterxml.jackson.annotation.JsonProperty("isInputOutputMemoryManagementUnitEnabled")
        private Boolean isInputOutputMemoryManagementUnitEnabled;

        /**
         * Whether the input-output memory management unit is enabled.
         *
         * @param isInputOutputMemoryManagementUnitEnabled the value to set
         * @return this builder
         */
        public Builder isInputOutputMemoryManagementUnitEnabled(
                Boolean isInputOutputMemoryManagementUnitEnabled) {
            this.isInputOutputMemoryManagementUnitEnabled =
                    isInputOutputMemoryManagementUnitEnabled;
            this.__explicitlySet__.add("isInputOutputMemoryManagementUnitEnabled");
            return this;
        }
        /** Instance Platform Configuration Configuration Map for flexible setting input. */
        @com.fasterxml.jackson.annotation.JsonProperty("configMap")
        private java.util.Map<String, String> configMap;

        /**
         * Instance Platform Configuration Configuration Map for flexible setting input.
         *
         * @param configMap the value to set
         * @return this builder
         */
        public Builder configMap(java.util.Map<String, String> configMap) {
            this.configMap = configMap;
            this.__explicitlySet__.add("configMap");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public AmdMilanBmGpuPlatformConfig build() {
            AmdMilanBmGpuPlatformConfig model =
                    new AmdMilanBmGpuPlatformConfig(
                            this.isSecureBootEnabled,
                            this.isTrustedPlatformModuleEnabled,
                            this.isMeasuredBootEnabled,
                            this.isMemoryEncryptionEnabled,
                            this.numaNodesPerSocket,
                            this.isSymmetricMultiThreadingEnabled,
                            this.isAccessControlServiceEnabled,
                            this.areVirtualInstructionsEnabled,
                            this.isInputOutputMemoryManagementUnitEnabled,
                            this.configMap);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(AmdMilanBmGpuPlatformConfig model) {
            if (model.wasPropertyExplicitlySet("isSecureBootEnabled")) {
                this.isSecureBootEnabled(model.getIsSecureBootEnabled());
            }
            if (model.wasPropertyExplicitlySet("isTrustedPlatformModuleEnabled")) {
                this.isTrustedPlatformModuleEnabled(model.getIsTrustedPlatformModuleEnabled());
            }
            if (model.wasPropertyExplicitlySet("isMeasuredBootEnabled")) {
                this.isMeasuredBootEnabled(model.getIsMeasuredBootEnabled());
            }
            if (model.wasPropertyExplicitlySet("isMemoryEncryptionEnabled")) {
                this.isMemoryEncryptionEnabled(model.getIsMemoryEncryptionEnabled());
            }
            if (model.wasPropertyExplicitlySet("numaNodesPerSocket")) {
                this.numaNodesPerSocket(model.getNumaNodesPerSocket());
            }
            if (model.wasPropertyExplicitlySet("isSymmetricMultiThreadingEnabled")) {
                this.isSymmetricMultiThreadingEnabled(model.getIsSymmetricMultiThreadingEnabled());
            }
            if (model.wasPropertyExplicitlySet("isAccessControlServiceEnabled")) {
                this.isAccessControlServiceEnabled(model.getIsAccessControlServiceEnabled());
            }
            if (model.wasPropertyExplicitlySet("areVirtualInstructionsEnabled")) {
                this.areVirtualInstructionsEnabled(model.getAreVirtualInstructionsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isInputOutputMemoryManagementUnitEnabled")) {
                this.isInputOutputMemoryManagementUnitEnabled(
                        model.getIsInputOutputMemoryManagementUnitEnabled());
            }
            if (model.wasPropertyExplicitlySet("configMap")) {
                this.configMap(model.getConfigMap());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AmdMilanBmGpuPlatformConfig(
            Boolean isSecureBootEnabled,
            Boolean isTrustedPlatformModuleEnabled,
            Boolean isMeasuredBootEnabled,
            Boolean isMemoryEncryptionEnabled,
            NumaNodesPerSocket numaNodesPerSocket,
            Boolean isSymmetricMultiThreadingEnabled,
            Boolean isAccessControlServiceEnabled,
            Boolean areVirtualInstructionsEnabled,
            Boolean isInputOutputMemoryManagementUnitEnabled,
            java.util.Map<String, String> configMap) {
        super(
                isSecureBootEnabled,
                isTrustedPlatformModuleEnabled,
                isMeasuredBootEnabled,
                isMemoryEncryptionEnabled);
        this.numaNodesPerSocket = numaNodesPerSocket;
        this.isSymmetricMultiThreadingEnabled = isSymmetricMultiThreadingEnabled;
        this.isAccessControlServiceEnabled = isAccessControlServiceEnabled;
        this.areVirtualInstructionsEnabled = areVirtualInstructionsEnabled;
        this.isInputOutputMemoryManagementUnitEnabled = isInputOutputMemoryManagementUnitEnabled;
        this.configMap = configMap;
    }

    /** The number of NUMA nodes per socket (NPS). */
    public enum NumaNodesPerSocket implements com.oracle.bmc.http.internal.BmcEnum {
        Nps0("NPS0"),
        Nps1("NPS1"),
        Nps2("NPS2"),
        Nps4("NPS4"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(NumaNodesPerSocket.class);

        private final String value;
        private static java.util.Map<String, NumaNodesPerSocket> map;

        static {
            map = new java.util.HashMap<>();
            for (NumaNodesPerSocket v : NumaNodesPerSocket.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        NumaNodesPerSocket(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static NumaNodesPerSocket create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'NumaNodesPerSocket', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /** The number of NUMA nodes per socket (NPS). */
    @com.fasterxml.jackson.annotation.JsonProperty("numaNodesPerSocket")
    private final NumaNodesPerSocket numaNodesPerSocket;

    /**
     * The number of NUMA nodes per socket (NPS).
     *
     * @return the value
     */
    public NumaNodesPerSocket getNumaNodesPerSocket() {
        return numaNodesPerSocket;
    }

    /**
     * Whether symmetric multithreading is enabled on the instance. Symmetric multithreading is also
     * called simultaneous multithreading (SMT) or Intel Hyper-Threading.
     *
     * <p>Intel and AMD processors have two hardware execution threads per core (OCPU). SMT permits
     * multiple independent threads of execution, to better use the resources and increase the
     * efficiency of the CPU. When multithreading is disabled, only one thread is permitted to run
     * on each core, which can provide higher or more predictable performance for some workloads.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isSymmetricMultiThreadingEnabled")
    private final Boolean isSymmetricMultiThreadingEnabled;

    /**
     * Whether symmetric multithreading is enabled on the instance. Symmetric multithreading is also
     * called simultaneous multithreading (SMT) or Intel Hyper-Threading.
     *
     * <p>Intel and AMD processors have two hardware execution threads per core (OCPU). SMT permits
     * multiple independent threads of execution, to better use the resources and increase the
     * efficiency of the CPU. When multithreading is disabled, only one thread is permitted to run
     * on each core, which can provide higher or more predictable performance for some workloads.
     *
     * @return the value
     */
    public Boolean getIsSymmetricMultiThreadingEnabled() {
        return isSymmetricMultiThreadingEnabled;
    }

    /**
     * Whether the Access Control Service is enabled on the instance. When enabled, the platform can
     * enforce PCIe device isolation, required for VFIO device pass-through.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isAccessControlServiceEnabled")
    private final Boolean isAccessControlServiceEnabled;

    /**
     * Whether the Access Control Service is enabled on the instance. When enabled, the platform can
     * enforce PCIe device isolation, required for VFIO device pass-through.
     *
     * @return the value
     */
    public Boolean getIsAccessControlServiceEnabled() {
        return isAccessControlServiceEnabled;
    }

    /**
     * Whether virtualization instructions are available. For example, Secure Virtual Machine for
     * AMD shapes or VT-x for Intel shapes.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("areVirtualInstructionsEnabled")
    private final Boolean areVirtualInstructionsEnabled;

    /**
     * Whether virtualization instructions are available. For example, Secure Virtual Machine for
     * AMD shapes or VT-x for Intel shapes.
     *
     * @return the value
     */
    public Boolean getAreVirtualInstructionsEnabled() {
        return areVirtualInstructionsEnabled;
    }

    /** Whether the input-output memory management unit is enabled. */
    @com.fasterxml.jackson.annotation.JsonProperty("isInputOutputMemoryManagementUnitEnabled")
    private final Boolean isInputOutputMemoryManagementUnitEnabled;

    /**
     * Whether the input-output memory management unit is enabled.
     *
     * @return the value
     */
    public Boolean getIsInputOutputMemoryManagementUnitEnabled() {
        return isInputOutputMemoryManagementUnitEnabled;
    }

    /** Instance Platform Configuration Configuration Map for flexible setting input. */
    @com.fasterxml.jackson.annotation.JsonProperty("configMap")
    private final java.util.Map<String, String> configMap;

    /**
     * Instance Platform Configuration Configuration Map for flexible setting input.
     *
     * @return the value
     */
    public java.util.Map<String, String> getConfigMap() {
        return configMap;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("AmdMilanBmGpuPlatformConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", numaNodesPerSocket=").append(String.valueOf(this.numaNodesPerSocket));
        sb.append(", isSymmetricMultiThreadingEnabled=")
                .append(String.valueOf(this.isSymmetricMultiThreadingEnabled));
        sb.append(", isAccessControlServiceEnabled=")
                .append(String.valueOf(this.isAccessControlServiceEnabled));
        sb.append(", areVirtualInstructionsEnabled=")
                .append(String.valueOf(this.areVirtualInstructionsEnabled));
        sb.append(", isInputOutputMemoryManagementUnitEnabled=")
                .append(String.valueOf(this.isInputOutputMemoryManagementUnitEnabled));
        sb.append(", configMap=").append(String.valueOf(this.configMap));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmdMilanBmGpuPlatformConfig)) {
            return false;
        }

        AmdMilanBmGpuPlatformConfig other = (AmdMilanBmGpuPlatformConfig) o;
        return java.util.Objects.equals(this.numaNodesPerSocket, other.numaNodesPerSocket)
                && java.util.Objects.equals(
                        this.isSymmetricMultiThreadingEnabled,
                        other.isSymmetricMultiThreadingEnabled)
                && java.util.Objects.equals(
                        this.isAccessControlServiceEnabled, other.isAccessControlServiceEnabled)
                && java.util.Objects.equals(
                        this.areVirtualInstructionsEnabled, other.areVirtualInstructionsEnabled)
                && java.util.Objects.equals(
                        this.isInputOutputMemoryManagementUnitEnabled,
                        other.isInputOutputMemoryManagementUnitEnabled)
                && java.util.Objects.equals(this.configMap, other.configMap)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.numaNodesPerSocket == null
                                ? 43
                                : this.numaNodesPerSocket.hashCode());
        result =
                (result * PRIME)
                        + (this.isSymmetricMultiThreadingEnabled == null
                                ? 43
                                : this.isSymmetricMultiThreadingEnabled.hashCode());
        result =
                (result * PRIME)
                        + (this.isAccessControlServiceEnabled == null
                                ? 43
                                : this.isAccessControlServiceEnabled.hashCode());
        result =
                (result * PRIME)
                        + (this.areVirtualInstructionsEnabled == null
                                ? 43
                                : this.areVirtualInstructionsEnabled.hashCode());
        result =
                (result * PRIME)
                        + (this.isInputOutputMemoryManagementUnitEnabled == null
                                ? 43
                                : this.isInputOutputMemoryManagementUnitEnabled.hashCode());
        result = (result * PRIME) + (this.configMap == null ? 43 : this.configMap.hashCode());
        return result;
    }
}
