/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.database.model;

/**
 * Details to update a database.
 *
 * <p>*Warning:** Oracle recommends that you avoid using any confidential information when you
 * supply string values using the API. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = UpdateDatabaseDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class UpdateDatabaseDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "dbBackupConfig",
        "dbHomeId",
        "newAdminPassword",
        "oldTdeWalletPassword",
        "newTdeWalletPassword",
        "freeformTags",
        "definedTags"
    })
    public UpdateDatabaseDetails(
            DbBackupConfig dbBackupConfig,
            String dbHomeId,
            String newAdminPassword,
            String oldTdeWalletPassword,
            String newTdeWalletPassword,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags) {
        super();
        this.dbBackupConfig = dbBackupConfig;
        this.dbHomeId = dbHomeId;
        this.newAdminPassword = newAdminPassword;
        this.oldTdeWalletPassword = oldTdeWalletPassword;
        this.newTdeWalletPassword = newTdeWalletPassword;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {

        @com.fasterxml.jackson.annotation.JsonProperty("dbBackupConfig")
        private DbBackupConfig dbBackupConfig;

        public Builder dbBackupConfig(DbBackupConfig dbBackupConfig) {
            this.dbBackupConfig = dbBackupConfig;
            this.__explicitlySet__.add("dbBackupConfig");
            return this;
        }
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * Database Home.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("dbHomeId")
        private String dbHomeId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * Database Home.
         *
         * @param dbHomeId the value to set
         * @return this builder
         */
        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            this.__explicitlySet__.add("dbHomeId");
            return this;
        }
        /**
         * A new strong password for SYS, SYSTEM, and the plugbable database ADMIN user. The
         * password must be at least nine characters and contain at least two uppercase, two
         * lowercase, two numeric, and two special characters. The special characters must be _,
         * \\#, or -.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("newAdminPassword")
        private String newAdminPassword;

        /**
         * A new strong password for SYS, SYSTEM, and the plugbable database ADMIN user. The
         * password must be at least nine characters and contain at least two uppercase, two
         * lowercase, two numeric, and two special characters. The special characters must be _,
         * \\#, or -.
         *
         * @param newAdminPassword the value to set
         * @return this builder
         */
        public Builder newAdminPassword(String newAdminPassword) {
            this.newAdminPassword = newAdminPassword;
            this.__explicitlySet__.add("newAdminPassword");
            return this;
        }
        /**
         * The existing TDE wallet password. You must provide the existing password in order to set
         * a new TDE wallet password.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("oldTdeWalletPassword")
        private String oldTdeWalletPassword;

        /**
         * The existing TDE wallet password. You must provide the existing password in order to set
         * a new TDE wallet password.
         *
         * @param oldTdeWalletPassword the value to set
         * @return this builder
         */
        public Builder oldTdeWalletPassword(String oldTdeWalletPassword) {
            this.oldTdeWalletPassword = oldTdeWalletPassword;
            this.__explicitlySet__.add("oldTdeWalletPassword");
            return this;
        }
        /**
         * The new password to open the TDE wallet. The password must be at least nine characters
         * and contain at least two uppercase, two lowercase, two numeric, and two special
         * characters. The special characters must be _, \\#, or -.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("newTdeWalletPassword")
        private String newTdeWalletPassword;

        /**
         * The new password to open the TDE wallet. The password must be at least nine characters
         * and contain at least two uppercase, two lowercase, two numeric, and two special
         * characters. The special characters must be _, \\#, or -.
         *
         * @param newTdeWalletPassword the value to set
         * @return this builder
         */
        public Builder newTdeWalletPassword(String newTdeWalletPassword) {
            this.newTdeWalletPassword = newTdeWalletPassword;
            this.__explicitlySet__.add("newTdeWalletPassword");
            return this;
        }
        /**
         * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
         * name, type, or namespace. For more information, see [Resource
         * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
         *
         * <p>Example: {@code {"Department": "Finance"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
         * name, type, or namespace. For more information, see [Resource
         * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
         *
         * <p>Example: {@code {"Department": "Finance"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace. For
         * more information, see [Resource
         * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace. For
         * more information, see [Resource
         * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public UpdateDatabaseDetails build() {
            UpdateDatabaseDetails model =
                    new UpdateDatabaseDetails(
                            this.dbBackupConfig,
                            this.dbHomeId,
                            this.newAdminPassword,
                            this.oldTdeWalletPassword,
                            this.newTdeWalletPassword,
                            this.freeformTags,
                            this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(UpdateDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("dbBackupConfig")) {
                this.dbBackupConfig(model.getDbBackupConfig());
            }
            if (model.wasPropertyExplicitlySet("dbHomeId")) {
                this.dbHomeId(model.getDbHomeId());
            }
            if (model.wasPropertyExplicitlySet("newAdminPassword")) {
                this.newAdminPassword(model.getNewAdminPassword());
            }
            if (model.wasPropertyExplicitlySet("oldTdeWalletPassword")) {
                this.oldTdeWalletPassword(model.getOldTdeWalletPassword());
            }
            if (model.wasPropertyExplicitlySet("newTdeWalletPassword")) {
                this.newTdeWalletPassword(model.getNewTdeWalletPassword());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @com.fasterxml.jackson.annotation.JsonProperty("dbBackupConfig")
    private final DbBackupConfig dbBackupConfig;

    public DbBackupConfig getDbBackupConfig() {
        return dbBackupConfig;
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * Database Home.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("dbHomeId")
    private final String dbHomeId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * Database Home.
     *
     * @return the value
     */
    public String getDbHomeId() {
        return dbHomeId;
    }

    /**
     * A new strong password for SYS, SYSTEM, and the plugbable database ADMIN user. The password
     * must be at least nine characters and contain at least two uppercase, two lowercase, two
     * numeric, and two special characters. The special characters must be _, \\#, or -.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("newAdminPassword")
    private final String newAdminPassword;

    /**
     * A new strong password for SYS, SYSTEM, and the plugbable database ADMIN user. The password
     * must be at least nine characters and contain at least two uppercase, two lowercase, two
     * numeric, and two special characters. The special characters must be _, \\#, or -.
     *
     * @return the value
     */
    public String getNewAdminPassword() {
        return newAdminPassword;
    }

    /**
     * The existing TDE wallet password. You must provide the existing password in order to set a
     * new TDE wallet password.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("oldTdeWalletPassword")
    private final String oldTdeWalletPassword;

    /**
     * The existing TDE wallet password. You must provide the existing password in order to set a
     * new TDE wallet password.
     *
     * @return the value
     */
    public String getOldTdeWalletPassword() {
        return oldTdeWalletPassword;
    }

    /**
     * The new password to open the TDE wallet. The password must be at least nine characters and
     * contain at least two uppercase, two lowercase, two numeric, and two special characters. The
     * special characters must be _, \\#, or -.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("newTdeWalletPassword")
    private final String newTdeWalletPassword;

    /**
     * The new password to open the TDE wallet. The password must be at least nine characters and
     * contain at least two uppercase, two lowercase, two numeric, and two special characters. The
     * special characters must be _, \\#, or -.
     *
     * @return the value
     */
    public String getNewTdeWalletPassword() {
        return newTdeWalletPassword;
    }

    /**
     * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
     * name, type, or namespace. For more information, see [Resource
     * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
     *
     * <p>Example: {@code {"Department": "Finance"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
     * name, type, or namespace. For more information, see [Resource
     * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
     *
     * <p>Example: {@code {"Department": "Finance"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. For more
     * information, see [Resource
     * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. For more
     * information, see [Resource
     * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("UpdateDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("dbBackupConfig=").append(String.valueOf(this.dbBackupConfig));
        sb.append(", dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(", newAdminPassword=").append("<redacted>");
        sb.append(", oldTdeWalletPassword=").append("<redacted>");
        sb.append(", newTdeWalletPassword=").append("<redacted>");
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDatabaseDetails)) {
            return false;
        }

        UpdateDatabaseDetails other = (UpdateDatabaseDetails) o;
        return java.util.Objects.equals(this.dbBackupConfig, other.dbBackupConfig)
                && java.util.Objects.equals(this.dbHomeId, other.dbHomeId)
                && java.util.Objects.equals(this.newAdminPassword, other.newAdminPassword)
                && java.util.Objects.equals(this.oldTdeWalletPassword, other.oldTdeWalletPassword)
                && java.util.Objects.equals(this.newTdeWalletPassword, other.newTdeWalletPassword)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.dbBackupConfig == null ? 43 : this.dbBackupConfig.hashCode());
        result = (result * PRIME) + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result =
                (result * PRIME)
                        + (this.newAdminPassword == null ? 43 : this.newAdminPassword.hashCode());
        result =
                (result * PRIME)
                        + (this.oldTdeWalletPassword == null
                                ? 43
                                : this.oldTdeWalletPassword.hashCode());
        result =
                (result * PRIME)
                        + (this.newTdeWalletPassword == null
                                ? 43
                                : this.newTdeWalletPassword.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
