/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/database/DeleteDbHomeExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use DeleteDbHomeRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
public class DeleteDbHomeRequest extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /**
     * The Database Home
     * [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
     */
    private String dbHomeId;

    /**
     * The Database Home
     * [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
     */
    public String getDbHomeId() {
        return dbHomeId;
    }
    /**
     * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the {@code
     * if-match} parameter to the value of the etag from a previous GET or POST response for that
     * resource. The resource will be updated or deleted only if the etag you provide matches the
     * resource's current etag value.
     */
    private String ifMatch;

    /**
     * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the {@code
     * if-match} parameter to the value of the etag from a previous GET or POST response for that
     * resource. The resource will be updated or deleted only if the etag you provide matches the
     * resource's current etag value.
     */
    public String getIfMatch() {
        return ifMatch;
    }
    /**
     * Whether to perform a final backup of the database or not. Default is false.
     *
     * <p>If you previously used RMAN or dbcli to configure backups and then you switch to using the
     * Console or the API for backups, a new backup configuration is created and associated with
     * your database. This means that you can no longer rely on your previously configured unmanaged
     * backups to work.
     *
     * <p>This parameter is used in multiple APIs. Refer to the API description for details on how
     * the operation uses it.
     */
    private Boolean performFinalBackup;

    /**
     * Whether to perform a final backup of the database or not. Default is false.
     *
     * <p>If you previously used RMAN or dbcli to configure backups and then you switch to using the
     * Console or the API for backups, a new backup configuration is created and associated with
     * your database. This means that you can no longer rely on your previously configured unmanaged
     * backups to work.
     *
     * <p>This parameter is used in multiple APIs. Refer to the API description for details on how
     * the operation uses it.
     */
    public Boolean getPerformFinalBackup() {
        return performFinalBackup;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    DeleteDbHomeRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /**
         * The Database Home
         * [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
         */
        private String dbHomeId = null;

        /**
         * The Database Home
         * [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
         *
         * @param dbHomeId the value to set
         * @return this builder instance
         */
        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        /**
         * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the
         * {@code if-match} parameter to the value of the etag from a previous GET or POST response
         * for that resource. The resource will be updated or deleted only if the etag you provide
         * matches the resource's current etag value.
         */
        private String ifMatch = null;

        /**
         * For optimistic concurrency control. In the PUT or DELETE call for a resource, set the
         * {@code if-match} parameter to the value of the etag from a previous GET or POST response
         * for that resource. The resource will be updated or deleted only if the etag you provide
         * matches the resource's current etag value.
         *
         * @param ifMatch the value to set
         * @return this builder instance
         */
        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        /**
         * Whether to perform a final backup of the database or not. Default is false.
         *
         * <p>If you previously used RMAN or dbcli to configure backups and then you switch to using
         * the Console or the API for backups, a new backup configuration is created and associated
         * with your database. This means that you can no longer rely on your previously configured
         * unmanaged backups to work.
         *
         * <p>This parameter is used in multiple APIs. Refer to the API description for details on
         * how the operation uses it.
         */
        private Boolean performFinalBackup = null;

        /**
         * Whether to perform a final backup of the database or not. Default is false.
         *
         * <p>If you previously used RMAN or dbcli to configure backups and then you switch to using
         * the Console or the API for backups, a new backup configuration is created and associated
         * with your database. This means that you can no longer rely on your previously configured
         * unmanaged backups to work.
         *
         * <p>This parameter is used in multiple APIs. Refer to the API description for details on
         * how the operation uses it.
         *
         * @param performFinalBackup the value to set
         * @return this builder instance
         */
        public Builder performFinalBackup(Boolean performFinalBackup) {
            this.performFinalBackup = performFinalBackup;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(DeleteDbHomeRequest o) {
            dbHomeId(o.getDbHomeId());
            ifMatch(o.getIfMatch());
            performFinalBackup(o.getPerformFinalBackup());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of DeleteDbHomeRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of DeleteDbHomeRequest
         */
        public DeleteDbHomeRequest build() {
            DeleteDbHomeRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of DeleteDbHomeRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of DeleteDbHomeRequest
         */
        public DeleteDbHomeRequest buildWithoutInvocationCallback() {
            DeleteDbHomeRequest request = new DeleteDbHomeRequest();
            request.dbHomeId = dbHomeId;
            request.ifMatch = ifMatch;
            request.performFinalBackup = performFinalBackup;
            return request;
            // new DeleteDbHomeRequest(dbHomeId, ifMatch, performFinalBackup);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .dbHomeId(dbHomeId)
                .ifMatch(ifMatch)
                .performFinalBackup(performFinalBackup);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",performFinalBackup=").append(String.valueOf(this.performFinalBackup));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDbHomeRequest)) {
            return false;
        }

        DeleteDbHomeRequest other = (DeleteDbHomeRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.dbHomeId, other.dbHomeId)
                && java.util.Objects.equals(this.ifMatch, other.ifMatch)
                && java.util.Objects.equals(this.performFinalBackup, other.performFinalBackup);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = (result * PRIME) + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result =
                (result * PRIME)
                        + (this.performFinalBackup == null
                                ? 43
                                : this.performFinalBackup.hashCode());
        return result;
    }
}
