/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.databasemanagement.model;

/**
 * Details to modify the AWR snapshot settings for a database. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20201101")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ModifySnapshotSettingsDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ModifySnapshotSettingsDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"retention", "interval"})
    public ModifySnapshotSettingsDetails(Integer retention, Integer interval) {
        super();
        this.retention = retention;
        this.interval = interval;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The retention time in minutes. Acceptable values are 0, 1440 to 52596000 (inclusive), and
         * null.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("retention")
        private Integer retention;

        /**
         * The retention time in minutes. Acceptable values are 0, 1440 to 52596000 (inclusive), and
         * null.
         *
         * @param retention the value to set
         * @return this builder
         */
        public Builder retention(Integer retention) {
            this.retention = retention;
            this.__explicitlySet__.add("retention");
            return this;
        }
        /**
         * The interval time in minutes. Acceptable values are 0, 10 to 527040 (inclusive), and
         * null.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("interval")
        private Integer interval;

        /**
         * The interval time in minutes. Acceptable values are 0, 10 to 527040 (inclusive), and
         * null.
         *
         * @param interval the value to set
         * @return this builder
         */
        public Builder interval(Integer interval) {
            this.interval = interval;
            this.__explicitlySet__.add("interval");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ModifySnapshotSettingsDetails build() {
            ModifySnapshotSettingsDetails model =
                    new ModifySnapshotSettingsDetails(this.retention, this.interval);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ModifySnapshotSettingsDetails model) {
            if (model.wasPropertyExplicitlySet("retention")) {
                this.retention(model.getRetention());
            }
            if (model.wasPropertyExplicitlySet("interval")) {
                this.interval(model.getInterval());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The retention time in minutes. Acceptable values are 0, 1440 to 52596000 (inclusive), and
     * null.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("retention")
    private final Integer retention;

    /**
     * The retention time in minutes. Acceptable values are 0, 1440 to 52596000 (inclusive), and
     * null.
     *
     * @return the value
     */
    public Integer getRetention() {
        return retention;
    }

    /**
     * The interval time in minutes. Acceptable values are 0, 10 to 527040 (inclusive), and null.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("interval")
    private final Integer interval;

    /**
     * The interval time in minutes. Acceptable values are 0, 10 to 527040 (inclusive), and null.
     *
     * @return the value
     */
    public Integer getInterval() {
        return interval;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ModifySnapshotSettingsDetails(");
        sb.append("super=").append(super.toString());
        sb.append("retention=").append(String.valueOf(this.retention));
        sb.append(", interval=").append(String.valueOf(this.interval));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifySnapshotSettingsDetails)) {
            return false;
        }

        ModifySnapshotSettingsDetails other = (ModifySnapshotSettingsDetails) o;
        return java.util.Objects.equals(this.retention, other.retention)
                && java.util.Objects.equals(this.interval, other.interval)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.retention == null ? 43 : this.retention.hashCode());
        result = (result * PRIME) + (this.interval == null ? 43 : this.interval.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
