/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.datascience.model;

/**
 * create job run details <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20190101")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = CreateJobRunScheduleActionDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "httpActionType")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class CreateJobRunScheduleActionDetails extends ScheduleHttpActionDetails {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {

        @com.fasterxml.jackson.annotation.JsonProperty("createJobRunDetails")
        private CreateJobRunDetails createJobRunDetails;

        public Builder createJobRunDetails(CreateJobRunDetails createJobRunDetails) {
            this.createJobRunDetails = createJobRunDetails;
            this.__explicitlySet__.add("createJobRunDetails");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public CreateJobRunScheduleActionDetails build() {
            CreateJobRunScheduleActionDetails model =
                    new CreateJobRunScheduleActionDetails(this.createJobRunDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(CreateJobRunScheduleActionDetails model) {
            if (model.wasPropertyExplicitlySet("createJobRunDetails")) {
                this.createJobRunDetails(model.getCreateJobRunDetails());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateJobRunScheduleActionDetails(CreateJobRunDetails createJobRunDetails) {
        super();
        this.createJobRunDetails = createJobRunDetails;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("createJobRunDetails")
    private final CreateJobRunDetails createJobRunDetails;

    public CreateJobRunDetails getCreateJobRunDetails() {
        return createJobRunDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("CreateJobRunScheduleActionDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", createJobRunDetails=").append(String.valueOf(this.createJobRunDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateJobRunScheduleActionDetails)) {
            return false;
        }

        CreateJobRunScheduleActionDetails other = (CreateJobRunScheduleActionDetails) o;
        return java.util.Objects.equals(this.createJobRunDetails, other.createJobRunDetails)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.createJobRunDetails == null
                                ? 43
                                : this.createJobRunDetails.hashCode());
        return result;
    }
}
