/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.datascience.model;

/**
 * A job run. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20190101")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = JobRun.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class JobRun extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "timeAccepted",
        "timeStarted",
        "timeFinished",
        "createdBy",
        "projectId",
        "compartmentId",
        "jobId",
        "displayName",
        "jobConfigurationOverrideDetails",
        "jobInfrastructureConfigurationDetails",
        "jobEnvironmentConfigurationOverrideDetails",
        "jobLogConfigurationOverrideDetails",
        "jobStorageMountConfigurationDetailsList",
        "logDetails",
        "lifecycleState",
        "lifecycleDetails",
        "freeformTags",
        "definedTags"
    })
    public JobRun(
            String id,
            java.util.Date timeAccepted,
            java.util.Date timeStarted,
            java.util.Date timeFinished,
            String createdBy,
            String projectId,
            String compartmentId,
            String jobId,
            String displayName,
            JobConfigurationDetails jobConfigurationOverrideDetails,
            JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails,
            JobEnvironmentConfigurationDetails jobEnvironmentConfigurationOverrideDetails,
            JobLogConfigurationDetails jobLogConfigurationOverrideDetails,
            java.util.List<StorageMountConfigurationDetails>
                    jobStorageMountConfigurationDetailsList,
            JobRunLogDetails logDetails,
            JobRunLifecycleState lifecycleState,
            String lifecycleDetails,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags) {
        super();
        this.id = id;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.createdBy = createdBy;
        this.projectId = projectId;
        this.compartmentId = compartmentId;
        this.jobId = jobId;
        this.displayName = displayName;
        this.jobConfigurationOverrideDetails = jobConfigurationOverrideDetails;
        this.jobInfrastructureConfigurationDetails = jobInfrastructureConfigurationDetails;
        this.jobEnvironmentConfigurationOverrideDetails =
                jobEnvironmentConfigurationOverrideDetails;
        this.jobLogConfigurationOverrideDetails = jobLogConfigurationOverrideDetails;
        this.jobStorageMountConfigurationDetailsList = jobStorageMountConfigurationDetailsList;
        this.logDetails = logDetails;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * job run.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * job run.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /**
         * The date and time the job run was accepted in the timestamp format defined by
         * [RFC3339](https://tools.ietf.org/html/rfc3339).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeAccepted")
        private java.util.Date timeAccepted;

        /**
         * The date and time the job run was accepted in the timestamp format defined by
         * [RFC3339](https://tools.ietf.org/html/rfc3339).
         *
         * @param timeAccepted the value to set
         * @return this builder
         */
        public Builder timeAccepted(java.util.Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }
        /**
         * The date and time the job run request was started in the timestamp format defined by
         * [RFC3339](https://tools.ietf.org/html/rfc3339).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
        private java.util.Date timeStarted;

        /**
         * The date and time the job run request was started in the timestamp format defined by
         * [RFC3339](https://tools.ietf.org/html/rfc3339).
         *
         * @param timeStarted the value to set
         * @return this builder
         */
        public Builder timeStarted(java.util.Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }
        /**
         * The date and time the job run request was finished in the timestamp format defined by
         * [RFC3339](https://tools.ietf.org/html/rfc3339).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
        private java.util.Date timeFinished;

        /**
         * The date and time the job run request was finished in the timestamp format defined by
         * [RFC3339](https://tools.ietf.org/html/rfc3339).
         *
         * @param timeFinished the value to set
         * @return this builder
         */
        public Builder timeFinished(java.util.Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * user who created the job run.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("createdBy")
        private String createdBy;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * user who created the job run.
         *
         * @param createdBy the value to set
         * @return this builder
         */
        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * project to associate the job run with.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("projectId")
        private String projectId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * project to associate the job run with.
         *
         * @param projectId the value to set
         * @return this builder
         */
        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * compartment where you want to create the job run.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * compartment where you want to create the job run.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * job.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("jobId")
        private String jobId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * job.
         *
         * @param jobId the value to set
         * @return this builder
         */
        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.__explicitlySet__.add("jobId");
            return this;
        }
        /** A user-friendly display name for the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * A user-friendly display name for the resource.
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("jobConfigurationOverrideDetails")
        private JobConfigurationDetails jobConfigurationOverrideDetails;

        public Builder jobConfigurationOverrideDetails(
                JobConfigurationDetails jobConfigurationOverrideDetails) {
            this.jobConfigurationOverrideDetails = jobConfigurationOverrideDetails;
            this.__explicitlySet__.add("jobConfigurationOverrideDetails");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("jobInfrastructureConfigurationDetails")
        private JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails;

        public Builder jobInfrastructureConfigurationDetails(
                JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails) {
            this.jobInfrastructureConfigurationDetails = jobInfrastructureConfigurationDetails;
            this.__explicitlySet__.add("jobInfrastructureConfigurationDetails");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("jobEnvironmentConfigurationOverrideDetails")
        private JobEnvironmentConfigurationDetails jobEnvironmentConfigurationOverrideDetails;

        public Builder jobEnvironmentConfigurationOverrideDetails(
                JobEnvironmentConfigurationDetails jobEnvironmentConfigurationOverrideDetails) {
            this.jobEnvironmentConfigurationOverrideDetails =
                    jobEnvironmentConfigurationOverrideDetails;
            this.__explicitlySet__.add("jobEnvironmentConfigurationOverrideDetails");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("jobLogConfigurationOverrideDetails")
        private JobLogConfigurationDetails jobLogConfigurationOverrideDetails;

        public Builder jobLogConfigurationOverrideDetails(
                JobLogConfigurationDetails jobLogConfigurationOverrideDetails) {
            this.jobLogConfigurationOverrideDetails = jobLogConfigurationOverrideDetails;
            this.__explicitlySet__.add("jobLogConfigurationOverrideDetails");
            return this;
        }
        /** Collection of JobStorageMountConfigurationDetails. */
        @com.fasterxml.jackson.annotation.JsonProperty("jobStorageMountConfigurationDetailsList")
        private java.util.List<StorageMountConfigurationDetails>
                jobStorageMountConfigurationDetailsList;

        /**
         * Collection of JobStorageMountConfigurationDetails.
         *
         * @param jobStorageMountConfigurationDetailsList the value to set
         * @return this builder
         */
        public Builder jobStorageMountConfigurationDetailsList(
                java.util.List<StorageMountConfigurationDetails>
                        jobStorageMountConfigurationDetailsList) {
            this.jobStorageMountConfigurationDetailsList = jobStorageMountConfigurationDetailsList;
            this.__explicitlySet__.add("jobStorageMountConfigurationDetailsList");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("logDetails")
        private JobRunLogDetails logDetails;

        public Builder logDetails(JobRunLogDetails logDetails) {
            this.logDetails = logDetails;
            this.__explicitlySet__.add("logDetails");
            return this;
        }
        /** The state of the job run. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private JobRunLifecycleState lifecycleState;

        /**
         * The state of the job run.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(JobRunLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }
        /** Details of the state of the job run. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleDetails")
        private String lifecycleDetails;

        /**
         * Details of the state of the job run.
         *
         * @param lifecycleDetails the value to set
         * @return this builder
         */
        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }
        /**
         * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
         * name, type, or namespace. See [Resource
         * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example:
         * {@code {"Department": "Finance"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
         * name, type, or namespace. See [Resource
         * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example:
         * {@code {"Department": "Finance"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace. See
         * [Resource Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
         * Example: {@code {"Operations": {"CostCenter": "42"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace. See
         * [Resource Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
         * Example: {@code {"Operations": {"CostCenter": "42"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public JobRun build() {
            JobRun model =
                    new JobRun(
                            this.id,
                            this.timeAccepted,
                            this.timeStarted,
                            this.timeFinished,
                            this.createdBy,
                            this.projectId,
                            this.compartmentId,
                            this.jobId,
                            this.displayName,
                            this.jobConfigurationOverrideDetails,
                            this.jobInfrastructureConfigurationDetails,
                            this.jobEnvironmentConfigurationOverrideDetails,
                            this.jobLogConfigurationOverrideDetails,
                            this.jobStorageMountConfigurationDetailsList,
                            this.logDetails,
                            this.lifecycleState,
                            this.lifecycleDetails,
                            this.freeformTags,
                            this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(JobRun model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("jobId")) {
                this.jobId(model.getJobId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("jobConfigurationOverrideDetails")) {
                this.jobConfigurationOverrideDetails(model.getJobConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("jobInfrastructureConfigurationDetails")) {
                this.jobInfrastructureConfigurationDetails(
                        model.getJobInfrastructureConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("jobEnvironmentConfigurationOverrideDetails")) {
                this.jobEnvironmentConfigurationOverrideDetails(
                        model.getJobEnvironmentConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("jobLogConfigurationOverrideDetails")) {
                this.jobLogConfigurationOverrideDetails(
                        model.getJobLogConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("jobStorageMountConfigurationDetailsList")) {
                this.jobStorageMountConfigurationDetailsList(
                        model.getJobStorageMountConfigurationDetailsList());
            }
            if (model.wasPropertyExplicitlySet("logDetails")) {
                this.logDetails(model.getLogDetails());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job
     * run.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job
     * run.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /**
     * The date and time the job run was accepted in the timestamp format defined by
     * [RFC3339](https://tools.ietf.org/html/rfc3339).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeAccepted")
    private final java.util.Date timeAccepted;

    /**
     * The date and time the job run was accepted in the timestamp format defined by
     * [RFC3339](https://tools.ietf.org/html/rfc3339).
     *
     * @return the value
     */
    public java.util.Date getTimeAccepted() {
        return timeAccepted;
    }

    /**
     * The date and time the job run request was started in the timestamp format defined by
     * [RFC3339](https://tools.ietf.org/html/rfc3339).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
    private final java.util.Date timeStarted;

    /**
     * The date and time the job run request was started in the timestamp format defined by
     * [RFC3339](https://tools.ietf.org/html/rfc3339).
     *
     * @return the value
     */
    public java.util.Date getTimeStarted() {
        return timeStarted;
    }

    /**
     * The date and time the job run request was finished in the timestamp format defined by
     * [RFC3339](https://tools.ietf.org/html/rfc3339).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
    private final java.util.Date timeFinished;

    /**
     * The date and time the job run request was finished in the timestamp format defined by
     * [RFC3339](https://tools.ietf.org/html/rfc3339).
     *
     * @return the value
     */
    public java.util.Date getTimeFinished() {
        return timeFinished;
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user
     * who created the job run.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("createdBy")
    private final String createdBy;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user
     * who created the job run.
     *
     * @return the value
     */
    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * project to associate the job run with.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("projectId")
    private final String projectId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * project to associate the job run with.
     *
     * @return the value
     */
    public String getProjectId() {
        return projectId;
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * compartment where you want to create the job run.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * compartment where you want to create the job run.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("jobId")
    private final String jobId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the job.
     *
     * @return the value
     */
    public String getJobId() {
        return jobId;
    }

    /** A user-friendly display name for the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * A user-friendly display name for the resource.
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("jobConfigurationOverrideDetails")
    private final JobConfigurationDetails jobConfigurationOverrideDetails;

    public JobConfigurationDetails getJobConfigurationOverrideDetails() {
        return jobConfigurationOverrideDetails;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("jobInfrastructureConfigurationDetails")
    private final JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails;

    public JobInfrastructureConfigurationDetails getJobInfrastructureConfigurationDetails() {
        return jobInfrastructureConfigurationDetails;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("jobEnvironmentConfigurationOverrideDetails")
    private final JobEnvironmentConfigurationDetails jobEnvironmentConfigurationOverrideDetails;

    public JobEnvironmentConfigurationDetails getJobEnvironmentConfigurationOverrideDetails() {
        return jobEnvironmentConfigurationOverrideDetails;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("jobLogConfigurationOverrideDetails")
    private final JobLogConfigurationDetails jobLogConfigurationOverrideDetails;

    public JobLogConfigurationDetails getJobLogConfigurationOverrideDetails() {
        return jobLogConfigurationOverrideDetails;
    }

    /** Collection of JobStorageMountConfigurationDetails. */
    @com.fasterxml.jackson.annotation.JsonProperty("jobStorageMountConfigurationDetailsList")
    private final java.util.List<StorageMountConfigurationDetails>
            jobStorageMountConfigurationDetailsList;

    /**
     * Collection of JobStorageMountConfigurationDetails.
     *
     * @return the value
     */
    public java.util.List<StorageMountConfigurationDetails>
            getJobStorageMountConfigurationDetailsList() {
        return jobStorageMountConfigurationDetailsList;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("logDetails")
    private final JobRunLogDetails logDetails;

    public JobRunLogDetails getLogDetails() {
        return logDetails;
    }

    /** The state of the job run. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final JobRunLifecycleState lifecycleState;

    /**
     * The state of the job run.
     *
     * @return the value
     */
    public JobRunLifecycleState getLifecycleState() {
        return lifecycleState;
    }

    /** Details of the state of the job run. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleDetails")
    private final String lifecycleDetails;

    /**
     * Details of the state of the job run.
     *
     * @return the value
     */
    public String getLifecycleDetails() {
        return lifecycleDetails;
    }

    /**
     * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
     * name, type, or namespace. See [Resource
     * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example:
     * {@code {"Department": "Finance"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Free-form tags for this resource. Each tag is a simple key-value pair with no predefined
     * name, type, or namespace. See [Resource
     * Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example:
     * {@code {"Department": "Finance"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. See
     * [Resource Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
     * Example: {@code {"Operations": {"CostCenter": "42"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. See
     * [Resource Tags](https://docs.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
     * Example: {@code {"Operations": {"CostCenter": "42"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("JobRun(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", projectId=").append(String.valueOf(this.projectId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", jobId=").append(String.valueOf(this.jobId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", jobConfigurationOverrideDetails=")
                .append(String.valueOf(this.jobConfigurationOverrideDetails));
        sb.append(", jobInfrastructureConfigurationDetails=")
                .append(String.valueOf(this.jobInfrastructureConfigurationDetails));
        sb.append(", jobEnvironmentConfigurationOverrideDetails=")
                .append(String.valueOf(this.jobEnvironmentConfigurationOverrideDetails));
        sb.append(", jobLogConfigurationOverrideDetails=")
                .append(String.valueOf(this.jobLogConfigurationOverrideDetails));
        sb.append(", jobStorageMountConfigurationDetailsList=")
                .append(String.valueOf(this.jobStorageMountConfigurationDetailsList));
        sb.append(", logDetails=").append(String.valueOf(this.logDetails));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobRun)) {
            return false;
        }

        JobRun other = (JobRun) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.timeAccepted, other.timeAccepted)
                && java.util.Objects.equals(this.timeStarted, other.timeStarted)
                && java.util.Objects.equals(this.timeFinished, other.timeFinished)
                && java.util.Objects.equals(this.createdBy, other.createdBy)
                && java.util.Objects.equals(this.projectId, other.projectId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.jobId, other.jobId)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(
                        this.jobConfigurationOverrideDetails, other.jobConfigurationOverrideDetails)
                && java.util.Objects.equals(
                        this.jobInfrastructureConfigurationDetails,
                        other.jobInfrastructureConfigurationDetails)
                && java.util.Objects.equals(
                        this.jobEnvironmentConfigurationOverrideDetails,
                        other.jobEnvironmentConfigurationOverrideDetails)
                && java.util.Objects.equals(
                        this.jobLogConfigurationOverrideDetails,
                        other.jobLogConfigurationOverrideDetails)
                && java.util.Objects.equals(
                        this.jobStorageMountConfigurationDetailsList,
                        other.jobStorageMountConfigurationDetailsList)
                && java.util.Objects.equals(this.logDetails, other.logDetails)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.lifecycleDetails, other.lifecycleDetails)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = (result * PRIME) + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = (result * PRIME) + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = (result * PRIME) + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = (result * PRIME) + (this.projectId == null ? 43 : this.projectId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result =
                (result * PRIME)
                        + (this.jobConfigurationOverrideDetails == null
                                ? 43
                                : this.jobConfigurationOverrideDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.jobInfrastructureConfigurationDetails == null
                                ? 43
                                : this.jobInfrastructureConfigurationDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.jobEnvironmentConfigurationOverrideDetails == null
                                ? 43
                                : this.jobEnvironmentConfigurationOverrideDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.jobLogConfigurationOverrideDetails == null
                                ? 43
                                : this.jobLogConfigurationOverrideDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.jobStorageMountConfigurationDetailsList == null
                                ? 43
                                : this.jobStorageMountConfigurationDetailsList.hashCode());
        result = (result * PRIME) + (this.logDetails == null ? 43 : this.logDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
