/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dblm.model;

/**
 * Singular information of an aggregated vulnerability datapoint. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240102")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = AggregatedVulnerabilitySummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class AggregatedVulnerabilitySummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "timestamp",
        "vulnerabilitiesCount",
        "registeredResourcesCount"
    })
    public AggregatedVulnerabilitySummary(
            java.util.Date timestamp,
            Integer vulnerabilitiesCount,
            Integer registeredResourcesCount) {
        super();
        this.timestamp = timestamp;
        this.vulnerabilitiesCount = vulnerabilitiesCount;
        this.registeredResourcesCount = registeredResourcesCount;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** UTC timestamp when the scan completed. */
        @com.fasterxml.jackson.annotation.JsonProperty("timestamp")
        private java.util.Date timestamp;

        /**
         * UTC timestamp when the scan completed.
         *
         * @param timestamp the value to set
         * @return this builder
         */
        public Builder timestamp(java.util.Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }
        /** Unresolved vulnerabilities that were found by the scan. */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilitiesCount")
        private Integer vulnerabilitiesCount;

        /**
         * Unresolved vulnerabilities that were found by the scan.
         *
         * @param vulnerabilitiesCount the value to set
         * @return this builder
         */
        public Builder vulnerabilitiesCount(Integer vulnerabilitiesCount) {
            this.vulnerabilitiesCount = vulnerabilitiesCount;
            this.__explicitlySet__.add("vulnerabilitiesCount");
            return this;
        }
        /** Registered databases against which the scan ran. */
        @com.fasterxml.jackson.annotation.JsonProperty("registeredResourcesCount")
        private Integer registeredResourcesCount;

        /**
         * Registered databases against which the scan ran.
         *
         * @param registeredResourcesCount the value to set
         * @return this builder
         */
        public Builder registeredResourcesCount(Integer registeredResourcesCount) {
            this.registeredResourcesCount = registeredResourcesCount;
            this.__explicitlySet__.add("registeredResourcesCount");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public AggregatedVulnerabilitySummary build() {
            AggregatedVulnerabilitySummary model =
                    new AggregatedVulnerabilitySummary(
                            this.timestamp,
                            this.vulnerabilitiesCount,
                            this.registeredResourcesCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(AggregatedVulnerabilitySummary model) {
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilitiesCount")) {
                this.vulnerabilitiesCount(model.getVulnerabilitiesCount());
            }
            if (model.wasPropertyExplicitlySet("registeredResourcesCount")) {
                this.registeredResourcesCount(model.getRegisteredResourcesCount());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** UTC timestamp when the scan completed. */
    @com.fasterxml.jackson.annotation.JsonProperty("timestamp")
    private final java.util.Date timestamp;

    /**
     * UTC timestamp when the scan completed.
     *
     * @return the value
     */
    public java.util.Date getTimestamp() {
        return timestamp;
    }

    /** Unresolved vulnerabilities that were found by the scan. */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilitiesCount")
    private final Integer vulnerabilitiesCount;

    /**
     * Unresolved vulnerabilities that were found by the scan.
     *
     * @return the value
     */
    public Integer getVulnerabilitiesCount() {
        return vulnerabilitiesCount;
    }

    /** Registered databases against which the scan ran. */
    @com.fasterxml.jackson.annotation.JsonProperty("registeredResourcesCount")
    private final Integer registeredResourcesCount;

    /**
     * Registered databases against which the scan ran.
     *
     * @return the value
     */
    public Integer getRegisteredResourcesCount() {
        return registeredResourcesCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("AggregatedVulnerabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", vulnerabilitiesCount=").append(String.valueOf(this.vulnerabilitiesCount));
        sb.append(", registeredResourcesCount=")
                .append(String.valueOf(this.registeredResourcesCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatedVulnerabilitySummary)) {
            return false;
        }

        AggregatedVulnerabilitySummary other = (AggregatedVulnerabilitySummary) o;
        return java.util.Objects.equals(this.timestamp, other.timestamp)
                && java.util.Objects.equals(this.vulnerabilitiesCount, other.vulnerabilitiesCount)
                && java.util.Objects.equals(
                        this.registeredResourcesCount, other.registeredResourcesCount)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilitiesCount == null
                                ? 43
                                : this.vulnerabilitiesCount.hashCode());
        result =
                (result * PRIME)
                        + (this.registeredResourcesCount == null
                                ? 43
                                : this.registeredResourcesCount.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
