/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dblm.model;

/**
 * The assessed Resources. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240102")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilityResourceSummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilityResourceSummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "name",
        "version",
        "release",
        "platform",
        "timeConfigCollected",
        "timeScanEnded",
        "imageId",
        "subscribedImage",
        "metricErrors",
        "childPdbs",
        "vulnerabilitiesSummary",
        "patchRecommendationsSummary",
        "patchRecommendationsDetails"
    })
    public VulnerabilityResourceSummary(
            String id,
            String name,
            String version,
            String release,
            String platform,
            java.util.Date timeConfigCollected,
            java.util.Date timeScanEnded,
            String imageId,
            String subscribedImage,
            java.util.List<MetricError> metricErrors,
            java.util.List<ChildPdb> childPdbs,
            Object vulnerabilitiesSummary,
            Object patchRecommendationsSummary,
            java.util.List<PatchRecommendationsDetailsSummary> patchRecommendationsDetails) {
        super();
        this.id = id;
        this.name = name;
        this.version = version;
        this.release = release;
        this.platform = platform;
        this.timeConfigCollected = timeConfigCollected;
        this.timeScanEnded = timeScanEnded;
        this.imageId = imageId;
        this.subscribedImage = subscribedImage;
        this.metricErrors = metricErrors;
        this.childPdbs = childPdbs;
        this.vulnerabilitiesSummary = vulnerabilitiesSummary;
        this.patchRecommendationsSummary = patchRecommendationsSummary;
        this.patchRecommendationsDetails = patchRecommendationsDetails;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The resource ID for this resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The resource ID for this resource.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** The name of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("name")
        private String name;

        /**
         * The name of the resource.
         *
         * @param name the value to set
         * @return this builder
         */
        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }
        /** A string representing the version of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("version")
        private String version;

        /**
         * A string representing the version of the resource.
         *
         * @param version the value to set
         * @return this builder
         */
        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }
        /** A string representing the release of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("release")
        private String release;

        /**
         * A string representing the release of the resource.
         *
         * @param release the value to set
         * @return this builder
         */
        public Builder release(String release) {
            this.release = release;
            this.__explicitlySet__.add("release");
            return this;
        }
        /** A string representing the platform of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("platform")
        private String platform;

        /**
         * A string representing the platform of the resource.
         *
         * @param platform the value to set
         * @return this builder
         */
        public Builder platform(String platform) {
            this.platform = platform;
            this.__explicitlySet__.add("platform");
            return this;
        }
        /** Time when the latest configuration collection happened. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeConfigCollected")
        private java.util.Date timeConfigCollected;

        /**
         * Time when the latest configuration collection happened.
         *
         * @param timeConfigCollected the value to set
         * @return this builder
         */
        public Builder timeConfigCollected(java.util.Date timeConfigCollected) {
            this.timeConfigCollected = timeConfigCollected;
            this.__explicitlySet__.add("timeConfigCollected");
            return this;
        }
        /** Time when the latest scan happened for the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeScanEnded")
        private java.util.Date timeScanEnded;

        /**
         * Time when the latest scan happened for the resource.
         *
         * @param timeScanEnded the value to set
         * @return this builder
         */
        public Builder timeScanEnded(java.util.Date timeScanEnded) {
            this.timeScanEnded = timeScanEnded;
            this.__explicitlySet__.add("timeScanEnded");
            return this;
        }
        /** Identifier for the resource is subscribed to. */
        @com.fasterxml.jackson.annotation.JsonProperty("imageId")
        private String imageId;

        /**
         * Identifier for the resource is subscribed to.
         *
         * @param imageId the value to set
         * @return this builder
         */
        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }
        /** Image the resource is subscribed to. */
        @com.fasterxml.jackson.annotation.JsonProperty("subscribedImage")
        private String subscribedImage;

        /**
         * Image the resource is subscribed to.
         *
         * @param subscribedImage the value to set
         * @return this builder
         */
        public Builder subscribedImage(String subscribedImage) {
            this.subscribedImage = subscribedImage;
            this.__explicitlySet__.add("subscribedImage");
            return this;
        }
        /** Metric errors. */
        @com.fasterxml.jackson.annotation.JsonProperty("metricErrors")
        private java.util.List<MetricError> metricErrors;

        /**
         * Metric errors.
         *
         * @param metricErrors the value to set
         * @return this builder
         */
        public Builder metricErrors(java.util.List<MetricError> metricErrors) {
            this.metricErrors = metricErrors;
            this.__explicitlySet__.add("metricErrors");
            return this;
        }
        /** PDBs for a CDB. */
        @com.fasterxml.jackson.annotation.JsonProperty("childPdbs")
        private java.util.List<ChildPdb> childPdbs;

        /**
         * PDBs for a CDB.
         *
         * @param childPdbs the value to set
         * @return this builder
         */
        public Builder childPdbs(java.util.List<ChildPdb> childPdbs) {
            this.childPdbs = childPdbs;
            this.__explicitlySet__.add("childPdbs");
            return this;
        }
        /** Summary of the resources that are registered and may or may not have vulnerabilities. */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilitiesSummary")
        private Object vulnerabilitiesSummary;

        /**
         * Summary of the resources that are registered and may or may not have vulnerabilities.
         *
         * @param vulnerabilitiesSummary the value to set
         * @return this builder
         */
        public Builder vulnerabilitiesSummary(Object vulnerabilitiesSummary) {
            this.vulnerabilitiesSummary = vulnerabilitiesSummary;
            this.__explicitlySet__.add("vulnerabilitiesSummary");
            return this;
        }
        /** Summary of the patch recommendations for databases. */
        @com.fasterxml.jackson.annotation.JsonProperty("patchRecommendationsSummary")
        private Object patchRecommendationsSummary;

        /**
         * Summary of the patch recommendations for databases.
         *
         * @param patchRecommendationsSummary the value to set
         * @return this builder
         */
        public Builder patchRecommendationsSummary(Object patchRecommendationsSummary) {
            this.patchRecommendationsSummary = patchRecommendationsSummary;
            this.__explicitlySet__.add("patchRecommendationsSummary");
            return this;
        }
        /** List of the patch recommendations for databases */
        @com.fasterxml.jackson.annotation.JsonProperty("patchRecommendationsDetails")
        private java.util.List<PatchRecommendationsDetailsSummary> patchRecommendationsDetails;

        /**
         * List of the patch recommendations for databases
         *
         * @param patchRecommendationsDetails the value to set
         * @return this builder
         */
        public Builder patchRecommendationsDetails(
                java.util.List<PatchRecommendationsDetailsSummary> patchRecommendationsDetails) {
            this.patchRecommendationsDetails = patchRecommendationsDetails;
            this.__explicitlySet__.add("patchRecommendationsDetails");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilityResourceSummary build() {
            VulnerabilityResourceSummary model =
                    new VulnerabilityResourceSummary(
                            this.id,
                            this.name,
                            this.version,
                            this.release,
                            this.platform,
                            this.timeConfigCollected,
                            this.timeScanEnded,
                            this.imageId,
                            this.subscribedImage,
                            this.metricErrors,
                            this.childPdbs,
                            this.vulnerabilitiesSummary,
                            this.patchRecommendationsSummary,
                            this.patchRecommendationsDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilityResourceSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("release")) {
                this.release(model.getRelease());
            }
            if (model.wasPropertyExplicitlySet("platform")) {
                this.platform(model.getPlatform());
            }
            if (model.wasPropertyExplicitlySet("timeConfigCollected")) {
                this.timeConfigCollected(model.getTimeConfigCollected());
            }
            if (model.wasPropertyExplicitlySet("timeScanEnded")) {
                this.timeScanEnded(model.getTimeScanEnded());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("subscribedImage")) {
                this.subscribedImage(model.getSubscribedImage());
            }
            if (model.wasPropertyExplicitlySet("metricErrors")) {
                this.metricErrors(model.getMetricErrors());
            }
            if (model.wasPropertyExplicitlySet("childPdbs")) {
                this.childPdbs(model.getChildPdbs());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilitiesSummary")) {
                this.vulnerabilitiesSummary(model.getVulnerabilitiesSummary());
            }
            if (model.wasPropertyExplicitlySet("patchRecommendationsSummary")) {
                this.patchRecommendationsSummary(model.getPatchRecommendationsSummary());
            }
            if (model.wasPropertyExplicitlySet("patchRecommendationsDetails")) {
                this.patchRecommendationsDetails(model.getPatchRecommendationsDetails());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** The resource ID for this resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The resource ID for this resource.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** The name of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("name")
    private final String name;

    /**
     * The name of the resource.
     *
     * @return the value
     */
    public String getName() {
        return name;
    }

    /** A string representing the version of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("version")
    private final String version;

    /**
     * A string representing the version of the resource.
     *
     * @return the value
     */
    public String getVersion() {
        return version;
    }

    /** A string representing the release of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("release")
    private final String release;

    /**
     * A string representing the release of the resource.
     *
     * @return the value
     */
    public String getRelease() {
        return release;
    }

    /** A string representing the platform of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("platform")
    private final String platform;

    /**
     * A string representing the platform of the resource.
     *
     * @return the value
     */
    public String getPlatform() {
        return platform;
    }

    /** Time when the latest configuration collection happened. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeConfigCollected")
    private final java.util.Date timeConfigCollected;

    /**
     * Time when the latest configuration collection happened.
     *
     * @return the value
     */
    public java.util.Date getTimeConfigCollected() {
        return timeConfigCollected;
    }

    /** Time when the latest scan happened for the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeScanEnded")
    private final java.util.Date timeScanEnded;

    /**
     * Time when the latest scan happened for the resource.
     *
     * @return the value
     */
    public java.util.Date getTimeScanEnded() {
        return timeScanEnded;
    }

    /** Identifier for the resource is subscribed to. */
    @com.fasterxml.jackson.annotation.JsonProperty("imageId")
    private final String imageId;

    /**
     * Identifier for the resource is subscribed to.
     *
     * @return the value
     */
    public String getImageId() {
        return imageId;
    }

    /** Image the resource is subscribed to. */
    @com.fasterxml.jackson.annotation.JsonProperty("subscribedImage")
    private final String subscribedImage;

    /**
     * Image the resource is subscribed to.
     *
     * @return the value
     */
    public String getSubscribedImage() {
        return subscribedImage;
    }

    /** Metric errors. */
    @com.fasterxml.jackson.annotation.JsonProperty("metricErrors")
    private final java.util.List<MetricError> metricErrors;

    /**
     * Metric errors.
     *
     * @return the value
     */
    public java.util.List<MetricError> getMetricErrors() {
        return metricErrors;
    }

    /** PDBs for a CDB. */
    @com.fasterxml.jackson.annotation.JsonProperty("childPdbs")
    private final java.util.List<ChildPdb> childPdbs;

    /**
     * PDBs for a CDB.
     *
     * @return the value
     */
    public java.util.List<ChildPdb> getChildPdbs() {
        return childPdbs;
    }

    /** Summary of the resources that are registered and may or may not have vulnerabilities. */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilitiesSummary")
    private final Object vulnerabilitiesSummary;

    /**
     * Summary of the resources that are registered and may or may not have vulnerabilities.
     *
     * @return the value
     */
    public Object getVulnerabilitiesSummary() {
        return vulnerabilitiesSummary;
    }

    /** Summary of the patch recommendations for databases. */
    @com.fasterxml.jackson.annotation.JsonProperty("patchRecommendationsSummary")
    private final Object patchRecommendationsSummary;

    /**
     * Summary of the patch recommendations for databases.
     *
     * @return the value
     */
    public Object getPatchRecommendationsSummary() {
        return patchRecommendationsSummary;
    }

    /** List of the patch recommendations for databases */
    @com.fasterxml.jackson.annotation.JsonProperty("patchRecommendationsDetails")
    private final java.util.List<PatchRecommendationsDetailsSummary> patchRecommendationsDetails;

    /**
     * List of the patch recommendations for databases
     *
     * @return the value
     */
    public java.util.List<PatchRecommendationsDetailsSummary> getPatchRecommendationsDetails() {
        return patchRecommendationsDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilityResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", release=").append(String.valueOf(this.release));
        sb.append(", platform=").append(String.valueOf(this.platform));
        sb.append(", timeConfigCollected=").append(String.valueOf(this.timeConfigCollected));
        sb.append(", timeScanEnded=").append(String.valueOf(this.timeScanEnded));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(", subscribedImage=").append(String.valueOf(this.subscribedImage));
        sb.append(", metricErrors=").append(String.valueOf(this.metricErrors));
        sb.append(", childPdbs=").append(String.valueOf(this.childPdbs));
        sb.append(", vulnerabilitiesSummary=").append(String.valueOf(this.vulnerabilitiesSummary));
        sb.append(", patchRecommendationsSummary=")
                .append(String.valueOf(this.patchRecommendationsSummary));
        sb.append(", patchRecommendationsDetails=")
                .append(String.valueOf(this.patchRecommendationsDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityResourceSummary)) {
            return false;
        }

        VulnerabilityResourceSummary other = (VulnerabilityResourceSummary) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.name, other.name)
                && java.util.Objects.equals(this.version, other.version)
                && java.util.Objects.equals(this.release, other.release)
                && java.util.Objects.equals(this.platform, other.platform)
                && java.util.Objects.equals(this.timeConfigCollected, other.timeConfigCollected)
                && java.util.Objects.equals(this.timeScanEnded, other.timeScanEnded)
                && java.util.Objects.equals(this.imageId, other.imageId)
                && java.util.Objects.equals(this.subscribedImage, other.subscribedImage)
                && java.util.Objects.equals(this.metricErrors, other.metricErrors)
                && java.util.Objects.equals(this.childPdbs, other.childPdbs)
                && java.util.Objects.equals(
                        this.vulnerabilitiesSummary, other.vulnerabilitiesSummary)
                && java.util.Objects.equals(
                        this.patchRecommendationsSummary, other.patchRecommendationsSummary)
                && java.util.Objects.equals(
                        this.patchRecommendationsDetails, other.patchRecommendationsDetails)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.name == null ? 43 : this.name.hashCode());
        result = (result * PRIME) + (this.version == null ? 43 : this.version.hashCode());
        result = (result * PRIME) + (this.release == null ? 43 : this.release.hashCode());
        result = (result * PRIME) + (this.platform == null ? 43 : this.platform.hashCode());
        result =
                (result * PRIME)
                        + (this.timeConfigCollected == null
                                ? 43
                                : this.timeConfigCollected.hashCode());
        result =
                (result * PRIME)
                        + (this.timeScanEnded == null ? 43 : this.timeScanEnded.hashCode());
        result = (result * PRIME) + (this.imageId == null ? 43 : this.imageId.hashCode());
        result =
                (result * PRIME)
                        + (this.subscribedImage == null ? 43 : this.subscribedImage.hashCode());
        result = (result * PRIME) + (this.metricErrors == null ? 43 : this.metricErrors.hashCode());
        result = (result * PRIME) + (this.childPdbs == null ? 43 : this.childPdbs.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilitiesSummary == null
                                ? 43
                                : this.vulnerabilitiesSummary.hashCode());
        result =
                (result * PRIME)
                        + (this.patchRecommendationsSummary == null
                                ? 43
                                : this.patchRecommendationsSummary.hashCode());
        result =
                (result * PRIME)
                        + (this.patchRecommendationsDetails == null
                                ? 43
                                : this.patchRecommendationsDetails.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
