/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dblm.model;

/**
 * The vulnerability summary. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240102")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilitySummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilitySummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "cveId",
        "description",
        "riskLevel",
        "score",
        "vulnerableResourcesCount"
    })
    public VulnerabilitySummary(
            String cveId,
            String description,
            String riskLevel,
            String score,
            Integer vulnerableResourcesCount) {
        super();
        this.cveId = cveId;
        this.description = description;
        this.riskLevel = riskLevel;
        this.score = score;
        this.vulnerableResourcesCount = vulnerableResourcesCount;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** CVE vulnerability ID */
        @com.fasterxml.jackson.annotation.JsonProperty("cveId")
        private String cveId;

        /**
         * CVE vulnerability ID
         *
         * @param cveId the value to set
         * @return this builder
         */
        public Builder cveId(String cveId) {
            this.cveId = cveId;
            this.__explicitlySet__.add("cveId");
            return this;
        }
        /** Vulnerability description */
        @com.fasterxml.jackson.annotation.JsonProperty("description")
        private String description;

        /**
         * Vulnerability description
         *
         * @param description the value to set
         * @return this builder
         */
        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }
        /** Risk level enumeration */
        @com.fasterxml.jackson.annotation.JsonProperty("riskLevel")
        private String riskLevel;

        /**
         * Risk level enumeration
         *
         * @param riskLevel the value to set
         * @return this builder
         */
        public Builder riskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
            this.__explicitlySet__.add("riskLevel");
            return this;
        }
        /** Vulnerability score */
        @com.fasterxml.jackson.annotation.JsonProperty("score")
        private String score;

        /**
         * Vulnerability score
         *
         * @param score the value to set
         * @return this builder
         */
        public Builder score(String score) {
            this.score = score;
            this.__explicitlySet__.add("score");
            return this;
        }
        /** Number of vulnerable resources */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerableResourcesCount")
        private Integer vulnerableResourcesCount;

        /**
         * Number of vulnerable resources
         *
         * @param vulnerableResourcesCount the value to set
         * @return this builder
         */
        public Builder vulnerableResourcesCount(Integer vulnerableResourcesCount) {
            this.vulnerableResourcesCount = vulnerableResourcesCount;
            this.__explicitlySet__.add("vulnerableResourcesCount");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilitySummary build() {
            VulnerabilitySummary model =
                    new VulnerabilitySummary(
                            this.cveId,
                            this.description,
                            this.riskLevel,
                            this.score,
                            this.vulnerableResourcesCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilitySummary model) {
            if (model.wasPropertyExplicitlySet("cveId")) {
                this.cveId(model.getCveId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("riskLevel")) {
                this.riskLevel(model.getRiskLevel());
            }
            if (model.wasPropertyExplicitlySet("score")) {
                this.score(model.getScore());
            }
            if (model.wasPropertyExplicitlySet("vulnerableResourcesCount")) {
                this.vulnerableResourcesCount(model.getVulnerableResourcesCount());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** CVE vulnerability ID */
    @com.fasterxml.jackson.annotation.JsonProperty("cveId")
    private final String cveId;

    /**
     * CVE vulnerability ID
     *
     * @return the value
     */
    public String getCveId() {
        return cveId;
    }

    /** Vulnerability description */
    @com.fasterxml.jackson.annotation.JsonProperty("description")
    private final String description;

    /**
     * Vulnerability description
     *
     * @return the value
     */
    public String getDescription() {
        return description;
    }

    /** Risk level enumeration */
    @com.fasterxml.jackson.annotation.JsonProperty("riskLevel")
    private final String riskLevel;

    /**
     * Risk level enumeration
     *
     * @return the value
     */
    public String getRiskLevel() {
        return riskLevel;
    }

    /** Vulnerability score */
    @com.fasterxml.jackson.annotation.JsonProperty("score")
    private final String score;

    /**
     * Vulnerability score
     *
     * @return the value
     */
    public String getScore() {
        return score;
    }

    /** Number of vulnerable resources */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerableResourcesCount")
    private final Integer vulnerableResourcesCount;

    /**
     * Number of vulnerable resources
     *
     * @return the value
     */
    public Integer getVulnerableResourcesCount() {
        return vulnerableResourcesCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("cveId=").append(String.valueOf(this.cveId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", riskLevel=").append(String.valueOf(this.riskLevel));
        sb.append(", score=").append(String.valueOf(this.score));
        sb.append(", vulnerableResourcesCount=")
                .append(String.valueOf(this.vulnerableResourcesCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilitySummary)) {
            return false;
        }

        VulnerabilitySummary other = (VulnerabilitySummary) o;
        return java.util.Objects.equals(this.cveId, other.cveId)
                && java.util.Objects.equals(this.description, other.description)
                && java.util.Objects.equals(this.riskLevel, other.riskLevel)
                && java.util.Objects.equals(this.score, other.score)
                && java.util.Objects.equals(
                        this.vulnerableResourcesCount, other.vulnerableResourcesCount)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.cveId == null ? 43 : this.cveId.hashCode());
        result = (result * PRIME) + (this.description == null ? 43 : this.description.hashCode());
        result = (result * PRIME) + (this.riskLevel == null ? 43 : this.riskLevel.hashCode());
        result = (result * PRIME) + (this.score == null ? 43 : this.score.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerableResourcesCount == null
                                ? 43
                                : this.vulnerableResourcesCount.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
