/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dblm.requests;

import com.oracle.bmc.dblm.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/dblm/ListAggregatedVulnerabilityDataExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListAggregatedVulnerabilityDataRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240102")
public class ListAggregatedVulnerabilityDataRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }
    /** The ID of the compartment in which to list resources. */
    private String compartmentId;

    /** The ID of the compartment in which to list resources. */
    public String getCompartmentId() {
        return compartmentId;
    }
    /** The created greater than. */
    private java.util.Date timeCreatedGreaterThan;

    /** The created greater than. */
    public java.util.Date getTimeCreatedGreaterThan() {
        return timeCreatedGreaterThan;
    }
    /** The time ended less than. */
    private java.util.Date timeEndedLessThan;

    /** The time ended less than. */
    public java.util.Date getTimeEndedLessThan() {
        return timeEndedLessThan;
    }
    /** A filter to return only database that match the given release version. */
    private String databaseRelease;

    /** A filter to return only database that match the given release version. */
    public String getDatabaseRelease() {
        return databaseRelease;
    }
    /** A filter to return only resources their lifecycleState matches the given lifecycleState. */
    private com.oracle.bmc.dblm.model.DblmVulnerability.LifecycleState lifecycleState;

    /** A filter to return only resources their lifecycleState matches the given lifecycleState. */
    public com.oracle.bmc.dblm.model.DblmVulnerability.LifecycleState getLifecycleState() {
        return lifecycleState;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * A token representing the position at which to start retrieving results. This must come from
     * the {@code opc-next-page} header field of a previous response.
     */
    private String page;

    /**
     * A token representing the position at which to start retrieving results. This must come from
     * the {@code opc-next-page} header field of a previous response.
     */
    public String getPage() {
        return page;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListAggregatedVulnerabilityDataRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /** The ID of the compartment in which to list resources. */
        private String compartmentId = null;

        /**
         * The ID of the compartment in which to list resources.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /** The created greater than. */
        private java.util.Date timeCreatedGreaterThan = null;

        /**
         * The created greater than.
         *
         * @param timeCreatedGreaterThan the value to set
         * @return this builder instance
         */
        public Builder timeCreatedGreaterThan(java.util.Date timeCreatedGreaterThan) {
            this.timeCreatedGreaterThan = timeCreatedGreaterThan;
            return this;
        }

        /** The time ended less than. */
        private java.util.Date timeEndedLessThan = null;

        /**
         * The time ended less than.
         *
         * @param timeEndedLessThan the value to set
         * @return this builder instance
         */
        public Builder timeEndedLessThan(java.util.Date timeEndedLessThan) {
            this.timeEndedLessThan = timeEndedLessThan;
            return this;
        }

        /** A filter to return only database that match the given release version. */
        private String databaseRelease = null;

        /**
         * A filter to return only database that match the given release version.
         *
         * @param databaseRelease the value to set
         * @return this builder instance
         */
        public Builder databaseRelease(String databaseRelease) {
            this.databaseRelease = databaseRelease;
            return this;
        }

        /**
         * A filter to return only resources their lifecycleState matches the given lifecycleState.
         */
        private com.oracle.bmc.dblm.model.DblmVulnerability.LifecycleState lifecycleState = null;

        /**
         * A filter to return only resources their lifecycleState matches the given lifecycleState.
         *
         * @param lifecycleState the value to set
         * @return this builder instance
         */
        public Builder lifecycleState(
                com.oracle.bmc.dblm.model.DblmVulnerability.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * A token representing the position at which to start retrieving results. This must come
         * from the {@code opc-next-page} header field of a previous response.
         */
        private String page = null;

        /**
         * A token representing the position at which to start retrieving results. This must come
         * from the {@code opc-next-page} header field of a previous response.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListAggregatedVulnerabilityDataRequest o) {
            opcRequestId(o.getOpcRequestId());
            compartmentId(o.getCompartmentId());
            timeCreatedGreaterThan(o.getTimeCreatedGreaterThan());
            timeEndedLessThan(o.getTimeEndedLessThan());
            databaseRelease(o.getDatabaseRelease());
            lifecycleState(o.getLifecycleState());
            limit(o.getLimit());
            page(o.getPage());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListAggregatedVulnerabilityDataRequest as configured by this
         * builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListAggregatedVulnerabilityDataRequest
         */
        public ListAggregatedVulnerabilityDataRequest build() {
            ListAggregatedVulnerabilityDataRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListAggregatedVulnerabilityDataRequest as configured by this
         * builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListAggregatedVulnerabilityDataRequest
         */
        public ListAggregatedVulnerabilityDataRequest buildWithoutInvocationCallback() {
            ListAggregatedVulnerabilityDataRequest request =
                    new ListAggregatedVulnerabilityDataRequest();
            request.opcRequestId = opcRequestId;
            request.compartmentId = compartmentId;
            request.timeCreatedGreaterThan = timeCreatedGreaterThan;
            request.timeEndedLessThan = timeEndedLessThan;
            request.databaseRelease = databaseRelease;
            request.lifecycleState = lifecycleState;
            request.limit = limit;
            request.page = page;
            return request;
            // new ListAggregatedVulnerabilityDataRequest(opcRequestId, compartmentId,
            // timeCreatedGreaterThan, timeEndedLessThan, databaseRelease, lifecycleState, limit,
            // page);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .opcRequestId(opcRequestId)
                .compartmentId(compartmentId)
                .timeCreatedGreaterThan(timeCreatedGreaterThan)
                .timeEndedLessThan(timeEndedLessThan)
                .databaseRelease(databaseRelease)
                .lifecycleState(lifecycleState)
                .limit(limit)
                .page(page);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",timeCreatedGreaterThan=").append(String.valueOf(this.timeCreatedGreaterThan));
        sb.append(",timeEndedLessThan=").append(String.valueOf(this.timeEndedLessThan));
        sb.append(",databaseRelease=").append(String.valueOf(this.databaseRelease));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAggregatedVulnerabilityDataRequest)) {
            return false;
        }

        ListAggregatedVulnerabilityDataRequest other = (ListAggregatedVulnerabilityDataRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(
                        this.timeCreatedGreaterThan, other.timeCreatedGreaterThan)
                && java.util.Objects.equals(this.timeEndedLessThan, other.timeEndedLessThan)
                && java.util.Objects.equals(this.databaseRelease, other.databaseRelease)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.timeCreatedGreaterThan == null
                                ? 43
                                : this.timeCreatedGreaterThan.hashCode());
        result =
                (result * PRIME)
                        + (this.timeEndedLessThan == null ? 43 : this.timeEndedLessThan.hashCode());
        result =
                (result * PRIME)
                        + (this.databaseRelease == null ? 43 : this.databaseRelease.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }
}
