/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dblm.requests;

import com.oracle.bmc.dblm.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/dblm/ListVulnerabilityScansExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListVulnerabilityScansRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240102")
public class ListVulnerabilityScansRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** The ID of the vulnerability scan. */
    private String vulnerabilityScanId;

    /** The ID of the vulnerability scan. */
    public String getVulnerabilityScanId() {
        return vulnerabilityScanId;
    }
    /** The ID of the compartment in which to list resources. */
    private String compartmentId;

    /** The ID of the compartment in which to list resources. */
    public String getCompartmentId() {
        return compartmentId;
    }
    /** A filter to return only resources that match the entire display name given. */
    private String displayName;

    /** A filter to return only resources that match the entire display name given. */
    public String getDisplayName() {
        return displayName;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * A token representing the position at which to start retrieving results. This must come from
     * the {@code opc-next-page} header field of a previous response.
     */
    private String page;

    /**
     * A token representing the position at which to start retrieving results. This must come from
     * the {@code opc-next-page} header field of a previous response.
     */
    public String getPage() {
        return page;
    }
    /** The sort order to use, either 'ASC' or 'DESC'. */
    private com.oracle.bmc.dblm.model.SortOrder sortOrder;

    /** The sort order to use, either 'ASC' or 'DESC'. */
    public com.oracle.bmc.dblm.model.SortOrder getSortOrder() {
        return sortOrder;
    }
    /** The field to sort by. Only one sort order may be provided. Default order is descending. */
    private SortBy sortBy;

    /** The field to sort by. Only one sort order may be provided. Default order is descending. */
    public enum SortBy implements com.oracle.bmc.http.internal.BmcEnum {
        Id("id"),
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        TimeEnded("timeEnded"),
        ;

        private final String value;
        private static java.util.Map<String, SortBy> map;

        static {
            map = new java.util.HashMap<>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }

        SortBy(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }
    };

    /** The field to sort by. Only one sort order may be provided. Default order is descending. */
    public SortBy getSortBy() {
        return sortBy;
    }
    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }
    /** The created greater than. */
    private java.util.Date timeCreatedGreaterThan;

    /** The created greater than. */
    public java.util.Date getTimeCreatedGreaterThan() {
        return timeCreatedGreaterThan;
    }
    /** The time ended less than. */
    private java.util.Date timeEndedLessThan;

    /** The time ended less than. */
    public java.util.Date getTimeEndedLessThan() {
        return timeEndedLessThan;
    }
    /**
     * Filter by one or more vulnerability scan status. Possible values are completed, running,
     * completed with error, aborted.
     */
    private java.util.List<VulnerabilityScanStatus> vulnerabilityScanStatus;

    /**
     * Filter by one or more vulnerability scan status. Possible values are completed, running,
     * completed with error, aborted.
     */
    public enum VulnerabilityScanStatus implements com.oracle.bmc.http.internal.BmcEnum {
        Completed("COMPLETED"),
        Error("ERROR"),
        Running("RUNNING"),
        Aborted("ABORTED"),
        ;

        private final String value;
        private static java.util.Map<String, VulnerabilityScanStatus> map;

        static {
            map = new java.util.HashMap<>();
            for (VulnerabilityScanStatus v : VulnerabilityScanStatus.values()) {
                map.put(v.getValue(), v);
            }
        }

        VulnerabilityScanStatus(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static VulnerabilityScanStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid VulnerabilityScanStatus: " + key);
        }
    };

    /**
     * Filter by one or more vulnerability scan status. Possible values are completed, running,
     * completed with error, aborted.
     */
    public java.util.List<VulnerabilityScanStatus> getVulnerabilityScanStatus() {
        return vulnerabilityScanStatus;
    }
    /** The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'. */
    private VulnerabilityScanType vulnerabilityScanType;

    /** The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'. */
    public enum VulnerabilityScanType implements com.oracle.bmc.http.internal.BmcEnum {
        Cve("CVE"),
        Patch("PATCH"),
        ImagePatch("IMAGE_PATCH"),
        ;

        private final String value;
        private static java.util.Map<String, VulnerabilityScanType> map;

        static {
            map = new java.util.HashMap<>();
            for (VulnerabilityScanType v : VulnerabilityScanType.values()) {
                map.put(v.getValue(), v);
            }
        }

        VulnerabilityScanType(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static VulnerabilityScanType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid VulnerabilityScanType: " + key);
        }
    };

    /** The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'. */
    public VulnerabilityScanType getVulnerabilityScanType() {
        return vulnerabilityScanType;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListVulnerabilityScansRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The ID of the vulnerability scan. */
        private String vulnerabilityScanId = null;

        /**
         * The ID of the vulnerability scan.
         *
         * @param vulnerabilityScanId the value to set
         * @return this builder instance
         */
        public Builder vulnerabilityScanId(String vulnerabilityScanId) {
            this.vulnerabilityScanId = vulnerabilityScanId;
            return this;
        }

        /** The ID of the compartment in which to list resources. */
        private String compartmentId = null;

        /**
         * The ID of the compartment in which to list resources.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /** A filter to return only resources that match the entire display name given. */
        private String displayName = null;

        /**
         * A filter to return only resources that match the entire display name given.
         *
         * @param displayName the value to set
         * @return this builder instance
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * A token representing the position at which to start retrieving results. This must come
         * from the {@code opc-next-page} header field of a previous response.
         */
        private String page = null;

        /**
         * A token representing the position at which to start retrieving results. This must come
         * from the {@code opc-next-page} header field of a previous response.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /** The sort order to use, either 'ASC' or 'DESC'. */
        private com.oracle.bmc.dblm.model.SortOrder sortOrder = null;

        /**
         * The sort order to use, either 'ASC' or 'DESC'.
         *
         * @param sortOrder the value to set
         * @return this builder instance
         */
        public Builder sortOrder(com.oracle.bmc.dblm.model.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /**
         * The field to sort by. Only one sort order may be provided. Default order is descending.
         */
        private SortBy sortBy = null;

        /**
         * The field to sort by. Only one sort order may be provided. Default order is descending.
         *
         * @param sortBy the value to set
         * @return this builder instance
         */
        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /** The created greater than. */
        private java.util.Date timeCreatedGreaterThan = null;

        /**
         * The created greater than.
         *
         * @param timeCreatedGreaterThan the value to set
         * @return this builder instance
         */
        public Builder timeCreatedGreaterThan(java.util.Date timeCreatedGreaterThan) {
            this.timeCreatedGreaterThan = timeCreatedGreaterThan;
            return this;
        }

        /** The time ended less than. */
        private java.util.Date timeEndedLessThan = null;

        /**
         * The time ended less than.
         *
         * @param timeEndedLessThan the value to set
         * @return this builder instance
         */
        public Builder timeEndedLessThan(java.util.Date timeEndedLessThan) {
            this.timeEndedLessThan = timeEndedLessThan;
            return this;
        }

        /**
         * Filter by one or more vulnerability scan status. Possible values are completed, running,
         * completed with error, aborted.
         */
        private java.util.List<VulnerabilityScanStatus> vulnerabilityScanStatus = null;

        /**
         * Filter by one or more vulnerability scan status. Possible values are completed, running,
         * completed with error, aborted.
         *
         * @param vulnerabilityScanStatus the value to set
         * @return this builder instance
         */
        public Builder vulnerabilityScanStatus(
                java.util.List<VulnerabilityScanStatus> vulnerabilityScanStatus) {
            this.vulnerabilityScanStatus = vulnerabilityScanStatus;
            return this;
        }

        /**
         * Singular setter. Filter by one or more vulnerability scan status. Possible values are
         * completed, running, completed with error, aborted.
         *
         * @param singularValue the singular value to set
         * @return this builder instance
         */
        public Builder vulnerabilityScanStatus(VulnerabilityScanStatus singularValue) {
            return this.vulnerabilityScanStatus(java.util.Arrays.asList(singularValue));
        }

        /** The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'. */
        private VulnerabilityScanType vulnerabilityScanType = null;

        /**
         * The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'.
         *
         * @param vulnerabilityScanType the value to set
         * @return this builder instance
         */
        public Builder vulnerabilityScanType(VulnerabilityScanType vulnerabilityScanType) {
            this.vulnerabilityScanType = vulnerabilityScanType;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListVulnerabilityScansRequest o) {
            vulnerabilityScanId(o.getVulnerabilityScanId());
            compartmentId(o.getCompartmentId());
            displayName(o.getDisplayName());
            limit(o.getLimit());
            page(o.getPage());
            sortOrder(o.getSortOrder());
            sortBy(o.getSortBy());
            opcRequestId(o.getOpcRequestId());
            timeCreatedGreaterThan(o.getTimeCreatedGreaterThan());
            timeEndedLessThan(o.getTimeEndedLessThan());
            vulnerabilityScanStatus(o.getVulnerabilityScanStatus());
            vulnerabilityScanType(o.getVulnerabilityScanType());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListVulnerabilityScansRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListVulnerabilityScansRequest
         */
        public ListVulnerabilityScansRequest build() {
            ListVulnerabilityScansRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListVulnerabilityScansRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListVulnerabilityScansRequest
         */
        public ListVulnerabilityScansRequest buildWithoutInvocationCallback() {
            ListVulnerabilityScansRequest request = new ListVulnerabilityScansRequest();
            request.vulnerabilityScanId = vulnerabilityScanId;
            request.compartmentId = compartmentId;
            request.displayName = displayName;
            request.limit = limit;
            request.page = page;
            request.sortOrder = sortOrder;
            request.sortBy = sortBy;
            request.opcRequestId = opcRequestId;
            request.timeCreatedGreaterThan = timeCreatedGreaterThan;
            request.timeEndedLessThan = timeEndedLessThan;
            request.vulnerabilityScanStatus = vulnerabilityScanStatus;
            request.vulnerabilityScanType = vulnerabilityScanType;
            return request;
            // new ListVulnerabilityScansRequest(vulnerabilityScanId, compartmentId, displayName,
            // limit, page, sortOrder, sortBy, opcRequestId, timeCreatedGreaterThan,
            // timeEndedLessThan, vulnerabilityScanStatus, vulnerabilityScanType);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .vulnerabilityScanId(vulnerabilityScanId)
                .compartmentId(compartmentId)
                .displayName(displayName)
                .limit(limit)
                .page(page)
                .sortOrder(sortOrder)
                .sortBy(sortBy)
                .opcRequestId(opcRequestId)
                .timeCreatedGreaterThan(timeCreatedGreaterThan)
                .timeEndedLessThan(timeEndedLessThan)
                .vulnerabilityScanStatus(vulnerabilityScanStatus)
                .vulnerabilityScanType(vulnerabilityScanType);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vulnerabilityScanId=").append(String.valueOf(this.vulnerabilityScanId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf(this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf(this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",timeCreatedGreaterThan=").append(String.valueOf(this.timeCreatedGreaterThan));
        sb.append(",timeEndedLessThan=").append(String.valueOf(this.timeEndedLessThan));
        sb.append(",vulnerabilityScanStatus=").append(String.valueOf(this.vulnerabilityScanStatus));
        sb.append(",vulnerabilityScanType=").append(String.valueOf(this.vulnerabilityScanType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListVulnerabilityScansRequest)) {
            return false;
        }

        ListVulnerabilityScansRequest other = (ListVulnerabilityScansRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.vulnerabilityScanId, other.vulnerabilityScanId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(this.sortOrder, other.sortOrder)
                && java.util.Objects.equals(this.sortBy, other.sortBy)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(
                        this.timeCreatedGreaterThan, other.timeCreatedGreaterThan)
                && java.util.Objects.equals(this.timeEndedLessThan, other.timeEndedLessThan)
                && java.util.Objects.equals(
                        this.vulnerabilityScanStatus, other.vulnerabilityScanStatus)
                && java.util.Objects.equals(
                        this.vulnerabilityScanType, other.vulnerabilityScanType);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.vulnerabilityScanId == null
                                ? 43
                                : this.vulnerabilityScanId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result = (result * PRIME) + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = (result * PRIME) + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result =
                (result * PRIME)
                        + (this.timeCreatedGreaterThan == null
                                ? 43
                                : this.timeCreatedGreaterThan.hashCode());
        result =
                (result * PRIME)
                        + (this.timeEndedLessThan == null ? 43 : this.timeEndedLessThan.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilityScanStatus == null
                                ? 43
                                : this.vulnerabilityScanStatus.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilityScanType == null
                                ? 43
                                : this.vulnerabilityScanType.hashCode());
        return result;
    }
}
