/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.filestorage.model;

/**
 * Source information for the file system. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20171215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = SourceDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class SourceDetails extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"parentFileSystemId", "sourceSnapshotId"})
    public SourceDetails(String parentFileSystemId, String sourceSnapshotId) {
        super();
        this.parentFileSystemId = parentFileSystemId;
        this.sourceSnapshotId = sourceSnapshotId;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * file system that contains the source snapshot of a cloned file system. See [Cloning a
         * File System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("parentFileSystemId")
        private String parentFileSystemId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * file system that contains the source snapshot of a cloned file system. See [Cloning a
         * File System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
         *
         * @param parentFileSystemId the value to set
         * @return this builder
         */
        public Builder parentFileSystemId(String parentFileSystemId) {
            this.parentFileSystemId = parentFileSystemId;
            this.__explicitlySet__.add("parentFileSystemId");
            return this;
        }
        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * source snapshot used to create a cloned file system. See [Cloning a File
         * System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("sourceSnapshotId")
        private String sourceSnapshotId;

        /**
         * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
         * source snapshot used to create a cloned file system. See [Cloning a File
         * System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
         *
         * @param sourceSnapshotId the value to set
         * @return this builder
         */
        public Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            this.__explicitlySet__.add("sourceSnapshotId");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public SourceDetails build() {
            SourceDetails model = new SourceDetails(this.parentFileSystemId, this.sourceSnapshotId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(SourceDetails model) {
            if (model.wasPropertyExplicitlySet("parentFileSystemId")) {
                this.parentFileSystemId(model.getParentFileSystemId());
            }
            if (model.wasPropertyExplicitlySet("sourceSnapshotId")) {
                this.sourceSnapshotId(model.getSourceSnapshotId());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file
     * system that contains the source snapshot of a cloned file system. See [Cloning a File
     * System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("parentFileSystemId")
    private final String parentFileSystemId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file
     * system that contains the source snapshot of a cloned file system. See [Cloning a File
     * System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
     *
     * @return the value
     */
    public String getParentFileSystemId() {
        return parentFileSystemId;
    }

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * source snapshot used to create a cloned file system. See [Cloning a File
     * System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("sourceSnapshotId")
    private final String sourceSnapshotId;

    /**
     * The [OCID](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the
     * source snapshot used to create a cloned file system. See [Cloning a File
     * System](https://docs.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
     *
     * @return the value
     */
    public String getSourceSnapshotId() {
        return sourceSnapshotId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("SourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("parentFileSystemId=").append(String.valueOf(this.parentFileSystemId));
        sb.append(", sourceSnapshotId=").append(String.valueOf(this.sourceSnapshotId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceDetails)) {
            return false;
        }

        SourceDetails other = (SourceDetails) o;
        return java.util.Objects.equals(this.parentFileSystemId, other.parentFileSystemId)
                && java.util.Objects.equals(this.sourceSnapshotId, other.sourceSnapshotId)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.parentFileSystemId == null
                                ? 43
                                : this.parentFileSystemId.hashCode());
        result =
                (result * PRIME)
                        + (this.sourceSnapshotId == null ? 43 : this.sourceSnapshotId.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
