/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.fleetappsmanagement.model;

/**
 * Details of Maintenance Window in Fleet Application Management. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20230831")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = MaintenanceWindow.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class MaintenanceWindow
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "compartmentId",
        "resourceRegion",
        "displayName",
        "description",
        "timeCreated",
        "timeUpdated",
        "maintenanceWindowType",
        "isOutage",
        "timeScheduleStart",
        "duration",
        "isRecurring",
        "recurrences",
        "taskInitiationCutoff",
        "lifecycleState",
        "lifecycleDetails",
        "freeformTags",
        "definedTags",
        "systemTags"
    })
    public MaintenanceWindow(
            String id,
            String compartmentId,
            String resourceRegion,
            String displayName,
            String description,
            java.util.Date timeCreated,
            java.util.Date timeUpdated,
            MaintenanceWindowType maintenanceWindowType,
            Boolean isOutage,
            java.util.Date timeScheduleStart,
            String duration,
            Boolean isRecurring,
            String recurrences,
            Integer taskInitiationCutoff,
            LifecycleState lifecycleState,
            String lifecycleDetails,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags,
            java.util.Map<String, java.util.Map<String, Object>> systemTags) {
        super();
        this.id = id;
        this.compartmentId = compartmentId;
        this.resourceRegion = resourceRegion;
        this.displayName = displayName;
        this.description = description;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.maintenanceWindowType = maintenanceWindowType;
        this.isOutage = isOutage;
        this.timeScheduleStart = timeScheduleStart;
        this.duration = duration;
        this.isRecurring = isRecurring;
        this.recurrences = recurrences;
        this.taskInitiationCutoff = taskInitiationCutoff;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The OCID of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The OCID of the resource.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** Tenancy OCID */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * Tenancy OCID
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /** Associated region */
        @com.fasterxml.jackson.annotation.JsonProperty("resourceRegion")
        private String resourceRegion;

        /**
         * Associated region
         *
         * @param resourceRegion the value to set
         * @return this builder
         */
        public Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            this.__explicitlySet__.add("resourceRegion");
            return this;
        }
        /**
         * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
         * confidential information.
         *
         * <p>Example: {@code My new resource}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
         * confidential information.
         *
         * <p>Example: {@code My new resource}
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /**
         * A user-friendly description. To provide some insight about the resource. Avoid entering
         * confidential information.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("description")
        private String description;

        /**
         * A user-friendly description. To provide some insight about the resource. Avoid entering
         * confidential information.
         *
         * @param description the value to set
         * @return this builder
         */
        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }
        /** The time this resource was created. An RFC3339 formatted datetime string. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeCreated")
        private java.util.Date timeCreated;

        /**
         * The time this resource was created. An RFC3339 formatted datetime string.
         *
         * @param timeCreated the value to set
         * @return this builder
         */
        public Builder timeCreated(java.util.Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }
        /** The time this resource was last updated. An RFC3339 formatted datetime string. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
        private java.util.Date timeUpdated;

        /**
         * The time this resource was last updated. An RFC3339 formatted datetime string.
         *
         * @param timeUpdated the value to set
         * @return this builder
         */
        public Builder timeUpdated(java.util.Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }
        /** Type of the MaintenanceWindow. */
        @com.fasterxml.jackson.annotation.JsonProperty("maintenanceWindowType")
        private MaintenanceWindowType maintenanceWindowType;

        /**
         * Type of the MaintenanceWindow.
         *
         * @param maintenanceWindowType the value to set
         * @return this builder
         */
        public Builder maintenanceWindowType(MaintenanceWindowType maintenanceWindowType) {
            this.maintenanceWindowType = maintenanceWindowType;
            this.__explicitlySet__.add("maintenanceWindowType");
            return this;
        }
        /**
         * Does the maintenenace window cause outage? An outage indicates whether a maintenance
         * window can consider operations that require downtime. It means a period when the
         * application is not accessible.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isOutage")
        private Boolean isOutage;

        /**
         * Does the maintenenace window cause outage? An outage indicates whether a maintenance
         * window can consider operations that require downtime. It means a period when the
         * application is not accessible.
         *
         * @param isOutage the value to set
         * @return this builder
         */
        public Builder isOutage(Boolean isOutage) {
            this.isOutage = isOutage;
            this.__explicitlySet__.add("isOutage");
            return this;
        }
        /** Specify the date and time of the day that the maintenance window starts. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeScheduleStart")
        private java.util.Date timeScheduleStart;

        /**
         * Specify the date and time of the day that the maintenance window starts.
         *
         * @param timeScheduleStart the value to set
         * @return this builder
         */
        public Builder timeScheduleStart(java.util.Date timeScheduleStart) {
            this.timeScheduleStart = timeScheduleStart;
            this.__explicitlySet__.add("timeScheduleStart");
            return this;
        }
        /**
         * Duration of the maintenance window. Specify how long the maintenance window remains open.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("duration")
        private String duration;

        /**
         * Duration of the maintenance window. Specify how long the maintenance window remains open.
         *
         * @param duration the value to set
         * @return this builder
         */
        public Builder duration(String duration) {
            this.duration = duration;
            this.__explicitlySet__.add("duration");
            return this;
        }
        /** Is this a recurring maintenance window? */
        @com.fasterxml.jackson.annotation.JsonProperty("isRecurring")
        private Boolean isRecurring;

        /**
         * Is this a recurring maintenance window?
         *
         * @param isRecurring the value to set
         * @return this builder
         */
        public Builder isRecurring(Boolean isRecurring) {
            this.isRecurring = isRecurring;
            this.__explicitlySet__.add("isRecurring");
            return this;
        }
        /**
         * Recurrence rule specification if maintenance window recurring. Specify the frequency of
         * running the maintenance window.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("recurrences")
        private String recurrences;

        /**
         * Recurrence rule specification if maintenance window recurring. Specify the frequency of
         * running the maintenance window.
         *
         * @param recurrences the value to set
         * @return this builder
         */
        public Builder recurrences(String recurrences) {
            this.recurrences = recurrences;
            this.__explicitlySet__.add("recurrences");
            return this;
        }
        /** Task initiation cutoff time for the maintenance window. */
        @com.fasterxml.jackson.annotation.JsonProperty("taskInitiationCutoff")
        private Integer taskInitiationCutoff;

        /**
         * Task initiation cutoff time for the maintenance window.
         *
         * @param taskInitiationCutoff the value to set
         * @return this builder
         */
        public Builder taskInitiationCutoff(Integer taskInitiationCutoff) {
            this.taskInitiationCutoff = taskInitiationCutoff;
            this.__explicitlySet__.add("taskInitiationCutoff");
            return this;
        }
        /** The current state of the MaintenanceWindow. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private LifecycleState lifecycleState;

        /**
         * The current state of the MaintenanceWindow.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }
        /**
         * A message describing the current state in more detail. For example, can be used to
         * provide actionable information for a resource in Failed state.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleDetails")
        private String lifecycleDetails;

        /**
         * A message describing the current state in more detail. For example, can be used to
         * provide actionable information for a resource in Failed state.
         *
         * @param lifecycleDetails the value to set
         * @return this builder
         */
        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }
        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }
        /**
         * System tags for this resource. Each key is predefined and scoped to a namespace. Example:
         * {@code {"orcl-cloud": {"free-tier-retained": "true"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("systemTags")
        private java.util.Map<String, java.util.Map<String, Object>> systemTags;

        /**
         * System tags for this resource. Each key is predefined and scoped to a namespace. Example:
         * {@code {"orcl-cloud": {"free-tier-retained": "true"}}}
         *
         * @param systemTags the value to set
         * @return this builder
         */
        public Builder systemTags(java.util.Map<String, java.util.Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public MaintenanceWindow build() {
            MaintenanceWindow model =
                    new MaintenanceWindow(
                            this.id,
                            this.compartmentId,
                            this.resourceRegion,
                            this.displayName,
                            this.description,
                            this.timeCreated,
                            this.timeUpdated,
                            this.maintenanceWindowType,
                            this.isOutage,
                            this.timeScheduleStart,
                            this.duration,
                            this.isRecurring,
                            this.recurrences,
                            this.taskInitiationCutoff,
                            this.lifecycleState,
                            this.lifecycleDetails,
                            this.freeformTags,
                            this.definedTags,
                            this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(MaintenanceWindow model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceRegion")) {
                this.resourceRegion(model.getResourceRegion());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindowType")) {
                this.maintenanceWindowType(model.getMaintenanceWindowType());
            }
            if (model.wasPropertyExplicitlySet("isOutage")) {
                this.isOutage(model.getIsOutage());
            }
            if (model.wasPropertyExplicitlySet("timeScheduleStart")) {
                this.timeScheduleStart(model.getTimeScheduleStart());
            }
            if (model.wasPropertyExplicitlySet("duration")) {
                this.duration(model.getDuration());
            }
            if (model.wasPropertyExplicitlySet("isRecurring")) {
                this.isRecurring(model.getIsRecurring());
            }
            if (model.wasPropertyExplicitlySet("recurrences")) {
                this.recurrences(model.getRecurrences());
            }
            if (model.wasPropertyExplicitlySet("taskInitiationCutoff")) {
                this.taskInitiationCutoff(model.getTaskInitiationCutoff());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** The OCID of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The OCID of the resource.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** Tenancy OCID */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * Tenancy OCID
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /** Associated region */
    @com.fasterxml.jackson.annotation.JsonProperty("resourceRegion")
    private final String resourceRegion;

    /**
     * Associated region
     *
     * @return the value
     */
    public String getResourceRegion() {
        return resourceRegion;
    }

    /**
     * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
     * confidential information.
     *
     * <p>Example: {@code My new resource}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
     * confidential information.
     *
     * <p>Example: {@code My new resource}
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * A user-friendly description. To provide some insight about the resource. Avoid entering
     * confidential information.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("description")
    private final String description;

    /**
     * A user-friendly description. To provide some insight about the resource. Avoid entering
     * confidential information.
     *
     * @return the value
     */
    public String getDescription() {
        return description;
    }

    /** The time this resource was created. An RFC3339 formatted datetime string. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeCreated")
    private final java.util.Date timeCreated;

    /**
     * The time this resource was created. An RFC3339 formatted datetime string.
     *
     * @return the value
     */
    public java.util.Date getTimeCreated() {
        return timeCreated;
    }

    /** The time this resource was last updated. An RFC3339 formatted datetime string. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
    private final java.util.Date timeUpdated;

    /**
     * The time this resource was last updated. An RFC3339 formatted datetime string.
     *
     * @return the value
     */
    public java.util.Date getTimeUpdated() {
        return timeUpdated;
    }

    /** Type of the MaintenanceWindow. */
    @com.fasterxml.jackson.annotation.JsonProperty("maintenanceWindowType")
    private final MaintenanceWindowType maintenanceWindowType;

    /**
     * Type of the MaintenanceWindow.
     *
     * @return the value
     */
    public MaintenanceWindowType getMaintenanceWindowType() {
        return maintenanceWindowType;
    }

    /**
     * Does the maintenenace window cause outage? An outage indicates whether a maintenance window
     * can consider operations that require downtime. It means a period when the application is not
     * accessible.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isOutage")
    private final Boolean isOutage;

    /**
     * Does the maintenenace window cause outage? An outage indicates whether a maintenance window
     * can consider operations that require downtime. It means a period when the application is not
     * accessible.
     *
     * @return the value
     */
    public Boolean getIsOutage() {
        return isOutage;
    }

    /** Specify the date and time of the day that the maintenance window starts. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeScheduleStart")
    private final java.util.Date timeScheduleStart;

    /**
     * Specify the date and time of the day that the maintenance window starts.
     *
     * @return the value
     */
    public java.util.Date getTimeScheduleStart() {
        return timeScheduleStart;
    }

    /** Duration of the maintenance window. Specify how long the maintenance window remains open. */
    @com.fasterxml.jackson.annotation.JsonProperty("duration")
    private final String duration;

    /**
     * Duration of the maintenance window. Specify how long the maintenance window remains open.
     *
     * @return the value
     */
    public String getDuration() {
        return duration;
    }

    /** Is this a recurring maintenance window? */
    @com.fasterxml.jackson.annotation.JsonProperty("isRecurring")
    private final Boolean isRecurring;

    /**
     * Is this a recurring maintenance window?
     *
     * @return the value
     */
    public Boolean getIsRecurring() {
        return isRecurring;
    }

    /**
     * Recurrence rule specification if maintenance window recurring. Specify the frequency of
     * running the maintenance window.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("recurrences")
    private final String recurrences;

    /**
     * Recurrence rule specification if maintenance window recurring. Specify the frequency of
     * running the maintenance window.
     *
     * @return the value
     */
    public String getRecurrences() {
        return recurrences;
    }

    /** Task initiation cutoff time for the maintenance window. */
    @com.fasterxml.jackson.annotation.JsonProperty("taskInitiationCutoff")
    private final Integer taskInitiationCutoff;

    /**
     * Task initiation cutoff time for the maintenance window.
     *
     * @return the value
     */
    public Integer getTaskInitiationCutoff() {
        return taskInitiationCutoff;
    }

    /** The current state of the MaintenanceWindow. */
    public enum LifecycleState implements com.oracle.bmc.http.internal.BmcEnum {
        Active("ACTIVE"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Deleting("DELETING"),
        Updating("UPDATING"),
        NeedsAttention("NEEDS_ATTENTION"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(LifecycleState.class);

        private final String value;
        private static java.util.Map<String, LifecycleState> map;

        static {
            map = new java.util.HashMap<>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        LifecycleState(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /** The current state of the MaintenanceWindow. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final LifecycleState lifecycleState;

    /**
     * The current state of the MaintenanceWindow.
     *
     * @return the value
     */
    public LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    /**
     * A message describing the current state in more detail. For example, can be used to provide
     * actionable information for a resource in Failed state.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleDetails")
    private final String lifecycleDetails;

    /**
     * A message describing the current state in more detail. For example, can be used to provide
     * actionable information for a resource in Failed state.
     *
     * @return the value
     */
    public String getLifecycleDetails() {
        return lifecycleDetails;
    }

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    /**
     * System tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"orcl-cloud": {"free-tier-retained": "true"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("systemTags")
    private final java.util.Map<String, java.util.Map<String, Object>> systemTags;

    /**
     * System tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"orcl-cloud": {"free-tier-retained": "true"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getSystemTags() {
        return systemTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("MaintenanceWindow(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceRegion=").append(String.valueOf(this.resourceRegion));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", maintenanceWindowType=").append(String.valueOf(this.maintenanceWindowType));
        sb.append(", isOutage=").append(String.valueOf(this.isOutage));
        sb.append(", timeScheduleStart=").append(String.valueOf(this.timeScheduleStart));
        sb.append(", duration=").append(String.valueOf(this.duration));
        sb.append(", isRecurring=").append(String.valueOf(this.isRecurring));
        sb.append(", recurrences=").append(String.valueOf(this.recurrences));
        sb.append(", taskInitiationCutoff=").append(String.valueOf(this.taskInitiationCutoff));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenanceWindow)) {
            return false;
        }

        MaintenanceWindow other = (MaintenanceWindow) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.resourceRegion, other.resourceRegion)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.description, other.description)
                && java.util.Objects.equals(this.timeCreated, other.timeCreated)
                && java.util.Objects.equals(this.timeUpdated, other.timeUpdated)
                && java.util.Objects.equals(this.maintenanceWindowType, other.maintenanceWindowType)
                && java.util.Objects.equals(this.isOutage, other.isOutage)
                && java.util.Objects.equals(this.timeScheduleStart, other.timeScheduleStart)
                && java.util.Objects.equals(this.duration, other.duration)
                && java.util.Objects.equals(this.isRecurring, other.isRecurring)
                && java.util.Objects.equals(this.recurrences, other.recurrences)
                && java.util.Objects.equals(this.taskInitiationCutoff, other.taskInitiationCutoff)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.lifecycleDetails, other.lifecycleDetails)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && java.util.Objects.equals(this.systemTags, other.systemTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.resourceRegion == null ? 43 : this.resourceRegion.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.description == null ? 43 : this.description.hashCode());
        result = (result * PRIME) + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = (result * PRIME) + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result =
                (result * PRIME)
                        + (this.maintenanceWindowType == null
                                ? 43
                                : this.maintenanceWindowType.hashCode());
        result = (result * PRIME) + (this.isOutage == null ? 43 : this.isOutage.hashCode());
        result =
                (result * PRIME)
                        + (this.timeScheduleStart == null ? 43 : this.timeScheduleStart.hashCode());
        result = (result * PRIME) + (this.duration == null ? 43 : this.duration.hashCode());
        result = (result * PRIME) + (this.isRecurring == null ? 43 : this.isRecurring.hashCode());
        result = (result * PRIME) + (this.recurrences == null ? 43 : this.recurrences.hashCode());
        result =
                (result * PRIME)
                        + (this.taskInitiationCutoff == null
                                ? 43
                                : this.taskInitiationCutoff.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
