/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.generativeaiagent.model;

/**
 * Configuration to store results generated by agent. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240531")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = OutputConfig.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class OutputConfig extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"outputLocation", "retentionPeriodInMinutes"})
    public OutputConfig(OutputLocation outputLocation, Integer retentionPeriodInMinutes) {
        super();
        this.outputLocation = outputLocation;
        this.retentionPeriodInMinutes = retentionPeriodInMinutes;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {

        @com.fasterxml.jackson.annotation.JsonProperty("outputLocation")
        private OutputLocation outputLocation;

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }
        /** Retention duration of the output data. */
        @com.fasterxml.jackson.annotation.JsonProperty("retentionPeriodInMinutes")
        private Integer retentionPeriodInMinutes;

        /**
         * Retention duration of the output data.
         *
         * @param retentionPeriodInMinutes the value to set
         * @return this builder
         */
        public Builder retentionPeriodInMinutes(Integer retentionPeriodInMinutes) {
            this.retentionPeriodInMinutes = retentionPeriodInMinutes;
            this.__explicitlySet__.add("retentionPeriodInMinutes");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public OutputConfig build() {
            OutputConfig model =
                    new OutputConfig(this.outputLocation, this.retentionPeriodInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(OutputConfig model) {
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInMinutes")) {
                this.retentionPeriodInMinutes(model.getRetentionPeriodInMinutes());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @com.fasterxml.jackson.annotation.JsonProperty("outputLocation")
    private final OutputLocation outputLocation;

    public OutputLocation getOutputLocation() {
        return outputLocation;
    }

    /** Retention duration of the output data. */
    @com.fasterxml.jackson.annotation.JsonProperty("retentionPeriodInMinutes")
    private final Integer retentionPeriodInMinutes;

    /**
     * Retention duration of the output data.
     *
     * @return the value
     */
    public Integer getRetentionPeriodInMinutes() {
        return retentionPeriodInMinutes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("OutputConfig(");
        sb.append("super=").append(super.toString());
        sb.append("outputLocation=").append(String.valueOf(this.outputLocation));
        sb.append(", retentionPeriodInMinutes=")
                .append(String.valueOf(this.retentionPeriodInMinutes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutputConfig)) {
            return false;
        }

        OutputConfig other = (OutputConfig) o;
        return java.util.Objects.equals(this.outputLocation, other.outputLocation)
                && java.util.Objects.equals(
                        this.retentionPeriodInMinutes, other.retentionPeriodInMinutes)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result =
                (result * PRIME)
                        + (this.retentionPeriodInMinutes == null
                                ? 43
                                : this.retentionPeriodInMinutes.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
