/**
 * Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.generativeaiagentruntime;

import com.oracle.bmc.generativeaiagentruntime.requests.*;
import com.oracle.bmc.generativeaiagentruntime.responses.*;

/**
 * OCI Generative AI Agents is a fully managed service that combines the power of large language
 * models (LLMs) with an intelligent retrieval system to create contextually relevant answers by
 * searching your knowledge base, making your AI applications smart and efficient.
 *
 * <p>OCI Generative AI Agents supports several ways to onboard your data and then allows you and
 * your customers to interact with your data using a chat interface or API.
 *
 * <p>Use the Generative AI Agents Client API to create and manage client chat sessions. A session
 * represents an interactive conversation initiated by a user through an API to engage with an
 * agent. It involves a series of exchanges where the user sends queries or prompts, and the agent
 * responds with relevant information, actions, or assistance based on the user's input. The session
 * persists for the duration of the interaction, maintaining context and continuity to provide
 * coherent and meaningful responses throughout the conversation.
 *
 * <p>For creating and managing agents, knowledge bases, data sources, endpoints, and data ingestion
 * jobs see the {@link #eNGenerative-ai-agentsLatest(ENGenerative-ai-agentsLatestRequest)
 * eNGenerative-ai-agentsLatest}.
 *
 * <p>To learn more about the service, see the [Generative AI Agents
 * documentation](https://docs.oracle.com/iaas/Content/generative-ai-agents/home.htm).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20240531")
public interface GenerativeAiAgentRuntimeAsync extends AutoCloseable {

    /** Rebuilds the client from scratch. Useful to refresh certificates. */
    void refreshClient();

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     *
     * @param endpoint The endpoint of the serice.
     */
    void setEndpoint(String endpoint);

    /** Gets the set endpoint for REST call (ex, https://www.example.com) */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     *
     * <p>Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the
     * endpoint. If the service is not available in this region, however, an
     * IllegalArgumentException will be raised.
     *
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     *
     * <p>Note, this will first try to map the region ID to a known Region and call {@link
     * #setRegion(Region) setRegion}.
     *
     * <p>If no known Region could be determined, it will create an endpoint based on the default
     * endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     *
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Determines whether realm specific endpoint should be used or not. Set
     * realmSpecificEndpointTemplateEnabled to "true" if the user wants to enable use of realm
     * specific endpoint template, otherwise set it to "false"
     *
     * @param realmSpecificEndpointTemplateEnabled flag to enable the use of realm specific endpoint
     *     template
     */
    void useRealmSpecificEndpointTemplate(boolean realmSpecificEndpointTemplateEnabled);

    /**
     * Chat on endpoint with provided messages.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChatResponse> chat(
            ChatRequest request,
            com.oracle.bmc.responses.AsyncHandler<ChatRequest, ChatResponse> handler);

    /**
     * A session represents an interactive conversation initiated by a user through an API to engage
     * with an agent. It involves a series of exchanges where the user sends queries or prompts, and
     * the agent responds with relevant information, actions, or assistance based on the user's
     * input. The session persists for the duration of the interaction, maintaining context and
     * continuity to provide coherent and meaningful responses throughout the conversation.Creates
     * an agent session.
     *
     * <p>Use this API to create an agent session.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateSessionResponse> createSession(
            CreateSessionRequest request,
            com.oracle.bmc.responses.AsyncHandler<CreateSessionRequest, CreateSessionResponse>
                    handler);

    /**
     * Delete a session and all its associated information.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteSessionResponse> deleteSession(
            DeleteSessionRequest request,
            com.oracle.bmc.responses.AsyncHandler<DeleteSessionRequest, DeleteSessionResponse>
                    handler);

    /**
     * Return the session resource identified by the session ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetSessionResponse> getSession(
            GetSessionRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetSessionRequest, GetSessionResponse> handler);

    /**
     * Returns metadata of provided knowledgeBase. Return available metadata with information of
     * field names, their types, supported operations, and possible values.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<RetrieveMetadataResponse> retrieveMetadata(
            RetrieveMetadataRequest request,
            com.oracle.bmc.responses.AsyncHandler<RetrieveMetadataRequest, RetrieveMetadataResponse>
                    handler);

    /**
     * Update session metadata, including but not limited to description, tags.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateSessionResponse> updateSession(
            UpdateSessionRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateSessionRequest, UpdateSessionResponse>
                    handler);
}
